package net.dungeonhub.api.model.i18n

import dev.kordex.core.i18n.types.Bundle
import dev.kordex.core.i18n.types.Key

public object Translations {
  public val bundle: Bundle = Bundle("dh-api.strings")

  public object Leaderboard {
    /**
     * Leaderboard | {name} score{suffix}
     */
    public val title: Key = Key("leaderboard.title")
        .withBundle(Translations.bundle)

    public object Title {
      /**
       * Total
       */
      public val total: Key = Key("leaderboard.title.total")
          .withBundle(Translations.bundle)
    }
  }

  public object RoleActions {
    public object ApplyAlways {
      /**
       * Apply always
       */
      public val readableName: Key = Key("role-actions.apply-always.readable-name")
          .withBundle(Translations.bundle)
    }

    public object ApplyAndRemoveWhenUnverified {
      /**
       * Apply when unverified, remove when verified
       */
      public val readableName: Key =
          Key("role-actions.apply-and-remove-when-unverified.readable-name")
          .withBundle(Translations.bundle)
    }

    public object ApplyAndRemoveWhenVerified {
      /**
       * Apply when verified, remove when unverified
       */
      public val readableName: Key =
          Key("role-actions.apply-and-remove-when-verified.readable-name")
          .withBundle(Translations.bundle)
    }

    public object ApplyWhenUnverified {
      /**
       * Apply when unverified
       */
      public val readableName: Key = Key("role-actions.apply-when-unverified.readable-name")
          .withBundle(Translations.bundle)
    }

    public object ApplyWhenVerified {
      /**
       * Apply when verified
       */
      public val readableName: Key = Key("role-actions.apply-when-verified.readable-name")
          .withBundle(Translations.bundle)
    }

    public object None {
      /**
       * Apply never
       */
      public val readableName: Key = Key("role-actions.none.readable-name")
          .withBundle(Translations.bundle)
    }

    public object RemoveWhenUnverified {
      /**
       * Remove when unverified
       */
      public val readableName: Key = Key("role-actions.remove-when-unverified.readable-name")
          .withBundle(Translations.bundle)
    }

    public object RemoveWhenVerified {
      /**
       * Remove when verified
       */
      public val readableName: Key = Key("role-actions.remove-when-verified.readable-name")
          .withBundle(Translations.bundle)
    }
  }

  public object ScoreType {
    public object Alltime {
      /**
       * All time
       */
      public val readableName: Key = Key("score-type.alltime.readable-name")
          .withBundle(Translations.bundle)

      /**
       * (all-time)
       */
      public val suffix: Key = Key("score-type.alltime.suffix")
          .withBundle(Translations.bundle)
    }

    public object Default {
      /**
       * Current
       */
      public val readableName: Key = Key("score-type.default.readable-name")
          .withBundle(Translations.bundle)
    }

    public object Event {
      /**
       * Event
       */
      public val readableName: Key = Key("score-type.event.readable-name")
          .withBundle(Translations.bundle)

      /**
       * (event)
       */
      public val suffix: Key = Key("score-type.event.suffix")
          .withBundle(Translations.bundle)
    }
  }
}
