/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.enums.ScoreResetType;
import net.dungeonhub.enums.ScoreType;
import net.dungeonhub.model.carry_type.CarryTypeModel;
import net.dungeonhub.model.score.ScoreLeaderboardModel;
import net.dungeonhub.model.score.ScoreModel;
import net.dungeonhub.model.score.ScoreResetModel;
import net.dungeonhub.model.score.ScoreUpdateModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import net.dungeonhub.structure.ModuleConnection;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bJL\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\b\u0002\u0010\u0013\u001a\u00020\u00142%\b\u0002\u0010\u001e\u001a\u001f0\u001f\u00a2\u0006\u001a\b \u0012\b\b!\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b\"\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0004"}, d2={"Lnet/dungeonhub/connection/ScoreConnection;", "Lnet/dungeonhub/structure/ModuleConnection;", "carryTypeModel", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "client", "Lnet/dungeonhub/client/AuthenticatedClient;", "<init>", "(Lnet/dungeonhub/model/carry_type/CarryTypeModel;Lnet/dungeonhub/client/AuthenticatedClient;)V", "getClient", "()Lnet/dungeonhub/client/AuthenticatedClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "SCORE_TYPE", "getScore", "Lnet/dungeonhub/model/score/ScoreModel;", "id", "", "scoreType", "Lnet/dungeonhub/enums/ScoreType;", "scores", "", "getScores", "()Ljava/util/List;", "updateScores", "scoreUpdateModel", "Lnet/dungeonhub/model/score/ScoreUpdateModel;", "loadLeaderboard", "Lnet/dungeonhub/model/score/ScoreLeaderboardModel;", "page", "", "Lorg/jetbrains/annotations/Range;", "from", "to", "userId", "(Lnet/dungeonhub/enums/ScoreType;ILjava/lang/Long;)Lnet/dungeonhub/model/score/ScoreLeaderboardModel;", "resetScore", "Lnet/dungeonhub/model/score/ScoreResetModel;", "scoreResetType", "Lnet/dungeonhub/enums/ScoreResetType;", "Companion"})
@SourceDebugExtension(value={"SMAP\nScoreConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreConnection.kt\nnet/dungeonhub/connection/ScoreConnection\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,119:1\n29#2:120\n29#2:121\n29#2:122\n*S KotlinDebug\n*F\n+ 1 ScoreConnection.kt\nnet/dungeonhub/connection/ScoreConnection\n*L\n46#1:120\n58#1:121\n74#1:122\n*E\n"})
public final class ScoreConnection
implements ModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticatedClient client;
    @NotNull
    private final String moduleApiPrefix;
    @NotNull
    private final String SCORE_TYPE;
    @NotNull
    private static final Map<CarryTypeModel, Companion.ClientlessScoreConnection> instances = new HashMap();

    public ScoreConnection(@NotNull CarryTypeModel carryTypeModel, @NotNull AuthenticatedClient client) {
        Intrinsics.checkNotNullParameter((Object)carryTypeModel, (String)"carryTypeModel");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "server/" + carryTypeModel.getServer().getId() + "/carry-type/" + carryTypeModel.getId() + "/score";
        this.SCORE_TYPE = "score-type";
    }

    @Override
    @NotNull
    public AuthenticatedClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final ScoreModel getScore(long id, @NotNull ScoreType scoreType) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        HttpUrl url = this.getApiUrl(id).addQueryParameter(this.SCORE_TYPE, scoreType.name()).build();
        Request request = this.getApiRequest(url).get().build();
        return (ScoreModel)Connection.executeRequest$default(this, request, null, ScoreConnection::getScore$lambda$0, 2, null);
    }

    @Nullable
    public final List<ScoreModel> getScores() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ScoreModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<ScoreModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<ScoreModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<ScoreModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final List<ScoreModel> getScores(long id) {
        HttpUrl url = this.getApiUrl("all").addQueryParameter("id", String.valueOf(id)).build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ScoreModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<ScoreModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<ScoreModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<ScoreModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final ScoreModel getScore(long id) {
        return this.getScore(id, ScoreType.Default);
    }

    @Nullable
    public final List<ScoreModel> updateScores(@NotNull ScoreUpdateModel scoreUpdateModel) {
        Intrinsics.checkNotNullParameter((Object)scoreUpdateModel, (String)"scoreUpdateModel");
        HttpUrl url = this.getApiUrl().build();
        RequestBody requestBody = RequestBody.Companion.create(scoreUpdateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ScoreModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<ScoreModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<ScoreModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<ScoreModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadLeaderboard(@NotNull ScoreType scoreType, int page, @Nullable Long userId) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        HttpUrl.Builder urlBuilder = this.getApiUrl("leaderboard").addQueryParameter(this.SCORE_TYPE, scoreType.name()).addQueryParameter("page", String.valueOf(page));
        if (userId != null) {
            urlBuilder.addQueryParameter("user", userId.toString());
        }
        Request request = this.getApiRequest(urlBuilder.build()).get().build();
        return (ScoreLeaderboardModel)Connection.executeRequest$default(this, request, null, ScoreConnection::loadLeaderboard$lambda$1, 2, null);
    }

    public static /* synthetic */ ScoreLeaderboardModel loadLeaderboard$default(ScoreConnection scoreConnection, ScoreType scoreType, int n, Long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            scoreType = ScoreType.Default;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            l = null;
        }
        return scoreConnection.loadLeaderboard(scoreType, n, l);
    }

    @Nullable
    public final ScoreResetModel resetScore(@NotNull ScoreResetType scoreResetType) {
        Intrinsics.checkNotNullParameter((Object)scoreResetType, (String)"scoreResetType");
        HttpUrl url = this.getApiUrl().addQueryParameter(this.SCORE_TYPE, scoreResetType.name()).build();
        Request request = Request.Builder.delete$default((Request.Builder)this.getApiRequest(url), null, (int)1, null).build();
        return (ScoreResetModel)Connection.executeRequest$default(this, request, null, ScoreConnection::resetScore$lambda$2, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadLeaderboard(@NotNull ScoreType scoreType, int page) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        return ScoreConnection.loadLeaderboard$default(this, scoreType, page, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadLeaderboard(@NotNull ScoreType scoreType) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        return ScoreConnection.loadLeaderboard$default(this, scoreType, 0, null, 6, null);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadLeaderboard() {
        return ScoreConnection.loadLeaderboard$default(this, null, 0, null, 7, null);
    }

    private static final ScoreModel getScore$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ScoreModel.Companion.fromJson(json);
    }

    private static final ScoreLeaderboardModel loadLeaderboard$lambda$1(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ScoreLeaderboardModel.Companion.fromJson(json);
    }

    private static final ScoreResetModel resetScore$lambda$2(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ScoreResetModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/dungeonhub/connection/ScoreConnection$Companion;", "", "<init>", "()V", "instances", "", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "Lnet/dungeonhub/connection/ScoreConnection$Companion$ClientlessScoreConnection;", "get", "carryTypeModel", "ClientlessScoreConnection", "client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientlessScoreConnection get(@NotNull CarryTypeModel carryTypeModel) {
            Intrinsics.checkNotNullParameter((Object)carryTypeModel, (String)"carryTypeModel");
            ClientlessScoreConnection clientlessScoreConnection = instances.computeIfAbsent(carryTypeModel, arg_0 -> Companion.get$lambda$1(Companion::get$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)clientlessScoreConnection, (String)"computeIfAbsent(...)");
            return clientlessScoreConnection;
        }

        private static final ClientlessScoreConnection get$lambda$0(CarryTypeModel it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ClientlessScoreConnection(it);
        }

        private static final ClientlessScoreConnection get$lambda$1(Function1 $tmp0, Object p0) {
            return (ClientlessScoreConnection)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/connection/ScoreConnection$Companion$ClientlessScoreConnection;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/ScoreConnection;", "carryTypeModel", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "<init>", "(Lnet/dungeonhub/model/carry_type/CarryTypeModel;)V", "getCarryTypeModel", "()Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
        public static final class ClientlessScoreConnection
        implements ClientlessConnection<ScoreConnection> {
            @NotNull
            private final CarryTypeModel carryTypeModel;

            public ClientlessScoreConnection(@NotNull CarryTypeModel carryTypeModel) {
                Intrinsics.checkNotNullParameter((Object)carryTypeModel, (String)"carryTypeModel");
                this.carryTypeModel = carryTypeModel;
            }

            @NotNull
            public final CarryTypeModel getCarryTypeModel() {
                return this.carryTypeModel;
            }

            @Override
            @NotNull
            public ScoreConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
                Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
                return new ScoreConnection(this.carryTypeModel, new AuthenticatedClient(authenticationProvider));
            }
        }
    }
}

