/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import dev.kord.core.behavior.MemberBehavior;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.connection.ReputationConnection;
import net.dungeonhub.model.discord_server.DiscordServerModel;
import net.dungeonhub.model.discord_user.DiscordUserModel;
import net.dungeonhub.model.reputation.ReputationCreationModel;
import net.dungeonhub.model.reputation.ReputationModel;
import net.dungeonhub.model.reputation.ReputationUpdateModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import net.dungeonhub.structure.ModuleConnection;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001aR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0005"}, d2={"Lnet/dungeonhub/connection/ReputationConnection;", "Lnet/dungeonhub/structure/ModuleConnection;", "server", "", "discordUser", "client", "Lnet/dungeonhub/client/AuthenticatedClient;", "<init>", "(JJLnet/dungeonhub/client/AuthenticatedClient;)V", "getClient", "()Lnet/dungeonhub/client/AuthenticatedClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "calculateReputation", "()Ljava/lang/Long;", "addReputation", "Lnet/dungeonhub/model/reputation/ReputationModel;", "creationModel", "Lnet/dungeonhub/model/reputation/ReputationCreationModel;", "updateReputation", "id", "updateModel", "Lnet/dungeonhub/model/reputation/ReputationUpdateModel;", "getReputations", "", "Companion"})
@SourceDebugExtension(value={"SMAP\nReputationConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReputationConnection.kt\nnet/dungeonhub/connection/ReputationConnection\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,88:1\n29#2:89\n*S KotlinDebug\n*F\n+ 1 ReputationConnection.kt\nnet/dungeonhub/connection/ReputationConnection\n*L\n61#1:89\n*E\n"})
public final class ReputationConnection
implements ModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticatedClient client;
    @NotNull
    private final String moduleApiPrefix;
    @NotNull
    private static final Map<Long, Map<Long, Companion.ClientlessReputationConnection>> instances = new HashMap();

    public ReputationConnection(long server, long discordUser, @NotNull AuthenticatedClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "server/" + server + "/discord-user/" + discordUser + "/reputation";
    }

    @Override
    @NotNull
    public AuthenticatedClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final Long calculateReputation() {
        HttpUrl url = this.getApiUrl("calculate").build();
        Request request = this.getApiRequest(url).get().build();
        return (Long)Connection.executeRequest$default(this, request, null, calculateReputation.1.INSTANCE, 2, null);
    }

    @Nullable
    public final ReputationModel addReputation(@NotNull ReputationCreationModel creationModel) {
        Intrinsics.checkNotNullParameter((Object)creationModel, (String)"creationModel");
        HttpUrl url = this.getApiUrl().build();
        RequestBody requestBody = RequestBody.Companion.create(creationModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).post(requestBody).build();
        return (ReputationModel)Connection.executeRequest$default(this, request, null, ReputationConnection::addReputation$lambda$0, 2, null);
    }

    @Nullable
    public final ReputationModel updateReputation(long id, @NotNull ReputationUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl(id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        return (ReputationModel)Connection.executeRequest$default(this, request, null, ReputationConnection::updateReputation$lambda$1, 2, null);
    }

    @Nullable
    public final List<ReputationModel> getReputations() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ReputationModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<ReputationModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<ReputationModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<ReputationModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    private static final ReputationModel addReputation$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ReputationModel.Companion.fromJson(json);
    }

    private static final ReputationModel updateReputation$lambda$1(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ReputationModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0086\u0002J\u0019\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\fH\u0086\u0002J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/dungeonhub/connection/ReputationConnection$Companion;", "", "<init>", "()V", "instances", "", "", "Lnet/dungeonhub/connection/ReputationConnection$Companion$ClientlessReputationConnection;", "get", "server", "discordUser", "Lnet/dungeonhub/model/discord_server/DiscordServerModel;", "Lnet/dungeonhub/model/discord_user/DiscordUserModel;", "member", "Ldev/kord/core/behavior/MemberBehavior;", "ClientlessReputationConnection", "client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientlessReputationConnection get(long server, long discordUser) {
            ClientlessReputationConnection clientlessReputationConnection = instances.computeIfAbsent(server, arg_0 -> Companion.get$lambda$1(arg_0 -> Companion.get$lambda$0(discordUser, arg_0), arg_0)).computeIfAbsent(discordUser, arg_0 -> Companion.get$lambda$3(arg_0 -> Companion.get$lambda$2(server, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)clientlessReputationConnection, (String)"computeIfAbsent(...)");
            return clientlessReputationConnection;
        }

        @NotNull
        public final ClientlessReputationConnection get(@NotNull DiscordServerModel server, @NotNull DiscordUserModel discordUser) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)discordUser, (String)"discordUser");
            return this.get(server.getId(), discordUser.getId());
        }

        @NotNull
        public final ClientlessReputationConnection get(@NotNull MemberBehavior member) {
            Intrinsics.checkNotNullParameter((Object)member, (String)"member");
            return this.get(member.getGuild().getId().getValue-s-VKNKU(), member.getId().getValue-s-VKNKU());
        }

        private static final Map get$lambda$0(long $discordUser, Long it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)$discordUser, (Object)new ClientlessReputationConnection(it, $discordUser))};
            return MapsKt.mutableMapOf((Pair[])pairArray);
        }

        private static final Map get$lambda$1(Function1 $tmp0, Object p0) {
            return (Map)$tmp0.invoke(p0);
        }

        private static final ClientlessReputationConnection get$lambda$2(long $server, Long it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ClientlessReputationConnection($server, it);
        }

        private static final ClientlessReputationConnection get$lambda$3(Function1 $tmp0, Object p0) {
            return (ClientlessReputationConnection)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000e"}, d2={"Lnet/dungeonhub/connection/ReputationConnection$Companion$ClientlessReputationConnection;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/ReputationConnection;", "server", "", "discordUser", "<init>", "(JJ)V", "getServer", "()J", "getDiscordUser", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
        public static final class ClientlessReputationConnection
        implements ClientlessConnection<ReputationConnection> {
            private final long server;
            private final long discordUser;

            public ClientlessReputationConnection(long server, long discordUser) {
                this.server = server;
                this.discordUser = discordUser;
            }

            public final long getServer() {
                return this.server;
            }

            public final long getDiscordUser() {
                return this.discordUser;
            }

            @Override
            @NotNull
            public ReputationConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
                Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
                return new ReputationConnection(this.server, this.discordUser, new AuthenticatedClient(authenticationProvider));
            }
        }
    }
}

