/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.util.List;
import java.util.UUID;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.client.DungeonHubClient;
import net.dungeonhub.connection.DiscordUserConnection;
import net.dungeonhub.model.discord_user.DiscordUserModel;
import net.dungeonhub.model.discord_user.DiscordUserUpdateModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.AuthenticatedModuleConnection;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020!R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0002"}, d2={"Lnet/dungeonhub/connection/DiscordUserConnection;", "Lnet/dungeonhub/structure/AuthenticatedModuleConnection;", "client", "Lnet/dungeonhub/client/DungeonHubClient;", "<init>", "(Lnet/dungeonhub/client/DungeonHubClient;)V", "getClient", "()Lnet/dungeonhub/client/DungeonHubClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "countLinkedUsers", "", "()Ljava/lang/Long;", "getById", "Lnet/dungeonhub/model/discord_user/DiscordUserModel;", "id", "getByIdOrCreate", "getLinkedById", "all", "", "getAll", "()Ljava/util/List;", "updateUser", "updateModel", "Lnet/dungeonhub/model/discord_user/DiscordUserUpdateModel;", "getCarryCount", "", "guildId", "(JJ)Ljava/lang/Integer;", "findUserByUuid", "uuid", "Ljava/util/UUID;", "Companion"})
@SourceDebugExtension(value={"SMAP\nDiscordUserConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscordUserConnection.kt\nnet/dungeonhub/connection/DiscordUserConnection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,97:1\n1#2:98\n29#3:99\n*S KotlinDebug\n*F\n+ 1 DiscordUserConnection.kt\nnet/dungeonhub/connection/DiscordUserConnection\n*L\n55#1:99\n*E\n"})
public final class DiscordUserConnection
extends AuthenticatedModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DungeonHubClient client;
    @NotNull
    private final String moduleApiPrefix;

    public DiscordUserConnection(@NotNull DungeonHubClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "discord-users";
    }

    @Override
    @NotNull
    public DungeonHubClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final Long countLinkedUsers() {
        HttpUrl url = this.getApiUrl("count-linked").build();
        Request request = new Request.Builder().url(url).build();
        return (Long)Connection.executeRequest$default(this, request, null, countLinkedUsers.1.INSTANCE, 2, null);
    }

    @Nullable
    public final DiscordUserModel getById(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = this.getApiRequest(url).get().build();
        return (DiscordUserModel)Connection.executeRequest$default(this, request, null, DiscordUserConnection::getById$lambda$0, 2, null);
    }

    @Nullable
    public final DiscordUserModel getByIdOrCreate(long id) {
        DiscordUserModel discordUserModel = this.getById(id);
        if (discordUserModel == null) {
            discordUserModel = this.updateUser(id, new DiscordUserUpdateModel(null));
        }
        return discordUserModel;
    }

    @Nullable
    public final DiscordUserModel getLinkedById(long id) {
        Object object;
        DiscordUserModel discordUserModel = this.getById(id);
        if (discordUserModel != null) {
            DiscordUserModel discordUserModel2;
            DiscordUserModel discordUserModel3 = discordUserModel2 = discordUserModel;
            boolean bl = false;
            object = discordUserModel3.getMinecraftId() != null ? discordUserModel2 : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final List<DiscordUserModel> getAll() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(DiscordUserModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<DiscordUserModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<DiscordUserModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<DiscordUserModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final DiscordUserModel updateUser(long id, @NotNull DiscordUserUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl(id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        return (DiscordUserModel)Connection.executeRequest$default(this, request, null, DiscordUserConnection::updateUser$lambda$2, 2, null);
    }

    @Nullable
    public final Integer getCarryCount(long id, long guildId) {
        HttpUrl url = this.getApiUrl(id + "/carries/" + guildId).build();
        Request request = this.getApiRequest(url).get().build();
        return (Integer)Connection.executeRequest$default(this, request, null, getCarryCount.1.INSTANCE, 2, null);
    }

    @Nullable
    public final DiscordUserModel findUserByUuid(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        HttpUrl url = this.getApiUrl("find").addQueryParameter("uuid", uuid.toString()).build();
        Request request = this.getApiRequest(url).get().build();
        return (DiscordUserModel)Connection.executeRequest$default(this, request, null, DiscordUserConnection::findUserByUuid$lambda$3, 2, null);
    }

    private static final DiscordUserModel getById$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return DiscordUserModel.Companion.fromJson(json);
    }

    private static final DiscordUserModel updateUser$lambda$2(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return DiscordUserModel.Companion.fromJson(json);
    }

    private static final DiscordUserModel findUserByUuid$lambda$3(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return DiscordUserModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lnet/dungeonhub/connection/DiscordUserConnection$Companion;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/DiscordUserConnection;", "<init>", "()V", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
    public static final class Companion
    implements ClientlessConnection<DiscordUserConnection> {
        private Companion() {
        }

        @Override
        @NotNull
        public DiscordUserConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
            Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
            return new DiscordUserConnection(new AuthenticatedClient(authenticationProvider));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

