/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.time.Instant;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.client.DungeonHubClient;
import net.dungeonhub.connection.DiscordServerConnection;
import net.dungeonhub.enums.ScoreType;
import net.dungeonhub.model.carry_difficulty.CarryDifficultyModel;
import net.dungeonhub.model.carry_tier.CarryTierModel;
import net.dungeonhub.model.discord_server.DiscordServerModel;
import net.dungeonhub.model.reputation.ReputationLeaderboardModel;
import net.dungeonhub.model.reputation.ReputationModel;
import net.dungeonhub.model.score.ScoreLeaderboardModel;
import net.dungeonhub.model.score.ScoreModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.AuthenticatedModuleConnection;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u000fJ\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0011J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000fJ\u001e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJT\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0013\u001a\u00020\u000f2\b\b\u0002\u0010!\u001a\u00020\"2%\b\u0002\u0010#\u001a\u001f0$\u00a2\u0006\u001a\b%\u0012\b\b&\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b'\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u000fH\u0007\u00a2\u0006\u0002\u0010)JH\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0013\u001a\u00020\u000f2%\b\u0002\u0010#\u001a\u001f0$\u00a2\u0006\u001a\b%\u0012\b\b&\u0012\u0004\b\u0004\u0010\u0000\u0012\f\b'\u0012\b\b\u0004\u0010\u00fe\u00ff\u00ff\u00ff\u000f2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010,JQ\u0010-\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u00101\u001a\u0004\u0018\u000102\u00a2\u0006\u0002\u00103J!\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\n\b\u0002\u00101\u001a\u0004\u0018\u000102\u00a2\u0006\u0002\u00105R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0002"}, d2={"Lnet/dungeonhub/connection/DiscordServerConnection;", "Lnet/dungeonhub/structure/AuthenticatedModuleConnection;", "client", "Lnet/dungeonhub/client/DungeonHubClient;", "<init>", "(Lnet/dungeonhub/client/DungeonHubClient;)V", "getClient", "()Lnet/dungeonhub/client/DungeonHubClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "findServerById", "Lnet/dungeonhub/model/discord_server/DiscordServerModel;", "id", "", "getAllCarryTiers", "", "Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "serverId", "getAllCarryDifficulties", "Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;", "loadAllServers", "getCarryTierFromCategory", "categoryId", "getReputation", "Lnet/dungeonhub/model/reputation/ReputationModel;", "reputationId", "getScores", "Lnet/dungeonhub/model/score/ScoreModel;", "serverModel", "loadTotalLeaderboard", "Lnet/dungeonhub/model/score/ScoreLeaderboardModel;", "scoreType", "Lnet/dungeonhub/enums/ScoreType;", "page", "", "Lorg/jetbrains/annotations/Range;", "from", "to", "userId", "(JLnet/dungeonhub/enums/ScoreType;ILjava/lang/Long;)Lnet/dungeonhub/model/score/ScoreLeaderboardModel;", "loadReputationLeaderboard", "Lnet/dungeonhub/model/reputation/ReputationLeaderboardModel;", "(JILjava/lang/Long;)Lnet/dungeonhub/model/reputation/ReputationLeaderboardModel;", "getTotalAmountOfMoneySpent", "carrierId", "carryTypeId", "carryTierId", "since", "Ljava/time/Instant;", "(JLjava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/time/Instant;)Ljava/lang/Long;", "getCarryAmount", "(JLjava/time/Instant;)Ljava/lang/Long;", "Companion"})
@SourceDebugExtension(value={"SMAP\nDiscordServerConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscordServerConnection.kt\nnet/dungeonhub/connection/DiscordServerConnection\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,190:1\n29#2:191\n29#2:192\n29#2:193\n29#2:194\n*S KotlinDebug\n*F\n+ 1 DiscordServerConnection.kt\nnet/dungeonhub/connection/DiscordServerConnection\n*L\n44#1:191\n64#1:192\n94#1:193\n54#1:194\n*E\n"})
public final class DiscordServerConnection
extends AuthenticatedModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DungeonHubClient client;
    @NotNull
    private final String moduleApiPrefix;

    public DiscordServerConnection(@NotNull DungeonHubClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "server";
    }

    @Override
    @NotNull
    public DungeonHubClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final DiscordServerModel findServerById(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = this.getApiRequest(url).get().build();
        return (DiscordServerModel)Connection.executeRequest$default(this, request, null, DiscordServerConnection::findServerById$lambda$0, 2, null);
    }

    @Nullable
    public final List<CarryTierModel> getAllCarryTiers(long serverId) {
        HttpUrl url = this.getApiUrl(serverId + "/carry-tiers").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryTierModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<CarryTierModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<CarryTierModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<CarryTierModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final List<CarryDifficultyModel> getAllCarryDifficulties(long serverId) {
        HttpUrl url = this.getApiUrl(serverId + "/carry-difficulties").build();
        Request request = this.getApiRequest(url).get().build();
        return (List)Connection.executeRequest$default(this, request, null, DiscordServerConnection::getAllCarryDifficulties$lambda$1, 2, null);
    }

    @Nullable
    public final List<DiscordServerModel> loadAllServers() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(DiscordServerModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<DiscordServerModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<DiscordServerModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<DiscordServerModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final CarryTierModel getCarryTierFromCategory(long serverId, long categoryId) {
        HttpUrl url = this.getApiUrl(serverId + "/category/" + categoryId + "/carry-tier").build();
        Request request = this.getApiRequest(url).get().build();
        return (CarryTierModel)Connection.executeRequest$default(this, request, null, DiscordServerConnection::getCarryTierFromCategory$lambda$2, 2, null);
    }

    @Nullable
    public final ReputationModel getReputation(long serverId, long reputationId) {
        HttpUrl url = this.getApiUrl(serverId + "/reputation/" + reputationId).build();
        Request request = this.getApiRequest(url).get().build();
        return (ReputationModel)Connection.executeRequest$default(this, request, null, DiscordServerConnection::getReputation$lambda$3, 2, null);
    }

    @Nullable
    public final List<ScoreModel> getScores(@NotNull DiscordServerModel serverModel, long id) {
        Intrinsics.checkNotNullParameter((Object)serverModel, (String)"serverModel");
        HttpUrl url = this.getApiUrl(serverModel.getId() + "/score/" + id).build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ScoreModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<ScoreModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<ScoreModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<ScoreModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadTotalLeaderboard(long serverId, @NotNull ScoreType scoreType, int page, @Nullable Long userId) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        HttpUrl.Builder urlBuilder = this.getApiUrl(serverId + "/total-leaderboard").addQueryParameter("score-type", scoreType.name()).addQueryParameter("page", String.valueOf(page));
        if (userId != null) {
            urlBuilder.addQueryParameter("user", userId.toString());
        }
        Request request = this.getApiRequest(urlBuilder.build()).get().build();
        return (ScoreLeaderboardModel)Connection.executeRequest$default(this, request, null, DiscordServerConnection::loadTotalLeaderboard$lambda$4, 2, null);
    }

    public static /* synthetic */ ScoreLeaderboardModel loadTotalLeaderboard$default(DiscordServerConnection discordServerConnection, long l, ScoreType scoreType, int n, Long l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            scoreType = ScoreType.Default;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            l2 = null;
        }
        return discordServerConnection.loadTotalLeaderboard(l, scoreType, n, l2);
    }

    @Nullable
    public final ReputationLeaderboardModel loadReputationLeaderboard(long serverId, int page, @Nullable Long userId) {
        HttpUrl.Builder urlBuilder = this.getApiUrl(serverId + "/reputation-leaderboard").addQueryParameter("page", String.valueOf(page));
        if (userId != null) {
            urlBuilder.addQueryParameter("user", userId.toString());
        }
        Request request = this.getApiRequest(urlBuilder.build()).get().build();
        return (ReputationLeaderboardModel)Connection.executeRequest$default(this, request, null, DiscordServerConnection::loadReputationLeaderboard$lambda$5, 2, null);
    }

    public static /* synthetic */ ReputationLeaderboardModel loadReputationLeaderboard$default(DiscordServerConnection discordServerConnection, long l, int n, Long l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            l2 = null;
        }
        return discordServerConnection.loadReputationLeaderboard(l, n, l2);
    }

    @Nullable
    public final Long getTotalAmountOfMoneySpent(long serverId, @Nullable Long userId, @Nullable Long carrierId, @Nullable Long carryTypeId, @Nullable Long carryTierId, @Nullable Instant since) {
        HttpUrl.Builder url = this.getApiUrl(serverId + "/total-money-spent");
        if (userId != null) {
            url.addQueryParameter("user", userId.toString());
        }
        if (carrierId != null) {
            url.addQueryParameter("carrier", carrierId.toString());
        }
        if (carryTypeId != null) {
            url.addQueryParameter("carry-type", carryTypeId.toString());
        }
        if (carryTierId != null) {
            url.addQueryParameter("carry-tier", carryTierId.toString());
        }
        if (since != null) {
            url.addQueryParameter("since", String.valueOf(since.toEpochMilli()));
        }
        Request request = this.getApiRequest(url.build()).get().build();
        return (Long)Connection.executeRequest$default(this, request, null, getTotalAmountOfMoneySpent.1.INSTANCE, 2, null);
    }

    public static /* synthetic */ Long getTotalAmountOfMoneySpent$default(DiscordServerConnection discordServerConnection, long l, Long l2, Long l3, Long l4, Long l5, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            l2 = null;
        }
        if ((n & 4) != 0) {
            l3 = null;
        }
        if ((n & 8) != 0) {
            l4 = null;
        }
        if ((n & 0x10) != 0) {
            l5 = null;
        }
        if ((n & 0x20) != 0) {
            instant = null;
        }
        return discordServerConnection.getTotalAmountOfMoneySpent(l, l2, l3, l4, l5, instant);
    }

    @Nullable
    public final Long getCarryAmount(long serverId, @Nullable Instant since) {
        HttpUrl.Builder url = this.getApiUrl(serverId + "/count-carries");
        if (since != null) {
            url.addQueryParameter("since", String.valueOf(since.toEpochMilli()));
        }
        Request request = this.getApiRequest(url.build()).get().build();
        return (Long)Connection.executeRequest$default(this, request, null, getCarryAmount.1.INSTANCE, 2, null);
    }

    public static /* synthetic */ Long getCarryAmount$default(DiscordServerConnection discordServerConnection, long l, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            instant = null;
        }
        return discordServerConnection.getCarryAmount(l, instant);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadTotalLeaderboard(long serverId, @NotNull ScoreType scoreType, int page) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        return DiscordServerConnection.loadTotalLeaderboard$default(this, serverId, scoreType, page, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadTotalLeaderboard(long serverId, @NotNull ScoreType scoreType) {
        Intrinsics.checkNotNullParameter((Object)scoreType, (String)"scoreType");
        return DiscordServerConnection.loadTotalLeaderboard$default(this, serverId, scoreType, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public final ScoreLeaderboardModel loadTotalLeaderboard(long serverId) {
        return DiscordServerConnection.loadTotalLeaderboard$default(this, serverId, null, 0, null, 14, null);
    }

    private static final DiscordServerModel findServerById$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return DiscordServerModel.Companion.fromJson(json);
    }

    private static final List getAllCarryDifficulties$lambda$1(String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        return (List)_MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryDifficultyModel.class)))).fromJson(s);
    }

    private static final CarryTierModel getCarryTierFromCategory$lambda$2(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTierModel.Companion.fromJson(json);
    }

    private static final ReputationModel getReputation$lambda$3(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ReputationModel.Companion.fromJson(json);
    }

    private static final ScoreLeaderboardModel loadTotalLeaderboard$lambda$4(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ScoreLeaderboardModel.Companion.fromJson(json);
    }

    private static final ReputationLeaderboardModel loadReputationLeaderboard$lambda$5(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return ReputationLeaderboardModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lnet/dungeonhub/connection/DiscordServerConnection$Companion;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/DiscordServerConnection;", "<init>", "()V", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
    public static final class Companion
    implements ClientlessConnection<DiscordServerConnection> {
        private Companion() {
        }

        @Override
        @NotNull
        public DiscordServerConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
            Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
            return new DiscordServerConnection(new AuthenticatedClient(authenticationProvider));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

