/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.model.discord_role.DiscordRoleCreationModel;
import net.dungeonhub.model.discord_role.DiscordRoleModel;
import net.dungeonhub.model.discord_role.DiscordRoleUpdateModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import net.dungeonhub.structure.ModuleConnection;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u0004"}, d2={"Lnet/dungeonhub/connection/DiscordRoleConnection;", "Lnet/dungeonhub/structure/ModuleConnection;", "server", "", "client", "Lnet/dungeonhub/client/AuthenticatedClient;", "<init>", "(JLnet/dungeonhub/client/AuthenticatedClient;)V", "getClient", "()Lnet/dungeonhub/client/AuthenticatedClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "getById", "Lnet/dungeonhub/model/discord_role/DiscordRoleModel;", "id", "addNewRole", "creationModel", "Lnet/dungeonhub/model/discord_role/DiscordRoleCreationModel;", "updateRole", "updateModel", "Lnet/dungeonhub/model/discord_role/DiscordRoleUpdateModel;", "allRoles", "", "getAllRoles", "()Ljava/util/List;", "Companion"})
@SourceDebugExtension(value={"SMAP\nDiscordRoleConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscordRoleConnection.kt\nnet/dungeonhub/connection/DiscordRoleConnection\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,78:1\n29#2:79\n*S KotlinDebug\n*F\n+ 1 DiscordRoleConnection.kt\nnet/dungeonhub/connection/DiscordRoleConnection\n*L\n62#1:79\n*E\n"})
public final class DiscordRoleConnection
implements ModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long server;
    @NotNull
    private final AuthenticatedClient client;
    @NotNull
    private final String moduleApiPrefix;
    @NotNull
    private static final Map<Long, Companion.ClientlessDiscordRoleConnection> instances = new HashMap();

    public DiscordRoleConnection(long server, @NotNull AuthenticatedClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.server = server;
        this.client = client;
        this.moduleApiPrefix = "server/" + this.server + "/roles";
    }

    @Override
    @NotNull
    public AuthenticatedClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final DiscordRoleModel getById(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = this.getApiRequest(url).get().build();
        return (DiscordRoleModel)Connection.executeRequest$default(this, request, null, DiscordRoleConnection::getById$lambda$0, 2, null);
    }

    @Nullable
    public final DiscordRoleModel addNewRole(@NotNull DiscordRoleCreationModel creationModel) {
        Intrinsics.checkNotNullParameter((Object)creationModel, (String)"creationModel");
        HttpUrl url = this.getApiUrl().build();
        RequestBody requestBody = RequestBody.Companion.create(creationModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).post(requestBody).build();
        return (DiscordRoleModel)Connection.executeRequest$default(this, request, null, DiscordRoleConnection::addNewRole$lambda$1, 2, null);
    }

    @Nullable
    public final DiscordRoleModel updateRole(long id, @NotNull DiscordRoleUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl(id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        return (DiscordRoleModel)Connection.executeRequest$default(this, request, null, DiscordRoleConnection::updateRole$lambda$2, 2, null);
    }

    @Nullable
    public final List<DiscordRoleModel> getAllRoles() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(DiscordRoleModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<DiscordRoleModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<DiscordRoleModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<DiscordRoleModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    private static final DiscordRoleModel getById$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return DiscordRoleModel.Companion.fromJson(json);
    }

    private static final DiscordRoleModel addNewRole$lambda$1(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return DiscordRoleModel.Companion.fromJson(json);
    }

    private static final DiscordRoleModel updateRole$lambda$2(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return DiscordRoleModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/dungeonhub/connection/DiscordRoleConnection$Companion;", "", "<init>", "()V", "instances", "", "", "Lnet/dungeonhub/connection/DiscordRoleConnection$Companion$ClientlessDiscordRoleConnection;", "get", "server", "ClientlessDiscordRoleConnection", "client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientlessDiscordRoleConnection get(long server) {
            ClientlessDiscordRoleConnection clientlessDiscordRoleConnection = instances.computeIfAbsent(server, arg_0 -> Companion.get$lambda$1(Companion::get$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)clientlessDiscordRoleConnection, (String)"computeIfAbsent(...)");
            return clientlessDiscordRoleConnection;
        }

        private static final ClientlessDiscordRoleConnection get$lambda$0(Long it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ClientlessDiscordRoleConnection(it);
        }

        private static final ClientlessDiscordRoleConnection get$lambda$1(Function1 $tmp0, Object p0) {
            return (ClientlessDiscordRoleConnection)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/connection/DiscordRoleConnection$Companion$ClientlessDiscordRoleConnection;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/DiscordRoleConnection;", "server", "", "<init>", "(J)V", "getServer", "()J", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
        public static final class ClientlessDiscordRoleConnection
        implements ClientlessConnection<DiscordRoleConnection> {
            private final long server;

            public ClientlessDiscordRoleConnection(long server) {
                this.server = server;
            }

            public final long getServer() {
                return this.server;
            }

            @Override
            @NotNull
            public DiscordRoleConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
                Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
                return new DiscordRoleConnection(this.server, new AuthenticatedClient(authenticationProvider));
            }
        }
    }
}

