/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.client.DungeonHubClient;
import net.dungeonhub.structure.AuthenticatedConnection;
import net.dungeonhub.structure.ClientlessConnection;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0002"}, d2={"Lnet/dungeonhub/connection/ContentConnection;", "Lnet/dungeonhub/structure/AuthenticatedConnection;", "client", "Lnet/dungeonhub/client/DungeonHubClient;", "<init>", "(Lnet/dungeonhub/client/DungeonHubClient;)V", "getClient", "()Lnet/dungeonhub/client/DungeonHubClient;", "apiUrl", "Lokhttp3/HttpUrl$Builder;", "getApiUrl", "()Lokhttp3/HttpUrl$Builder;", "uri", "", "getStaticUrl", "getCdnUrl", "performUpload", "data", "", "url", "Lokhttp3/HttpUrl;", "uploadFile", "fileName", "downloadFile", "Companion"})
public final class ContentConnection
extends AuthenticatedConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DungeonHubClient client;

    public ContentConnection(@NotNull DungeonHubClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    @Override
    @NotNull
    public DungeonHubClient getClient() {
        return this.client;
    }

    private final HttpUrl.Builder getApiUrl() {
        return HttpUrl.Companion.get(DungeonHubClient.Companion.getApiUrl() + "cdn/").newBuilder();
    }

    @NotNull
    public final HttpUrl.Builder getApiUrl(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return HttpUrl.Companion.get(DungeonHubClient.Companion.getApiUrl() + "cdn/" + uri).newBuilder();
    }

    @NotNull
    public final HttpUrl.Builder getStaticUrl(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String prefix = DungeonHubClient.Companion.getStaticUrl();
        CharSequence charSequence = prefix;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return this.getCdnUrl("static/" + uri);
        }
        return HttpUrl.Companion.get(prefix + uri).newBuilder();
    }

    @NotNull
    public final HttpUrl.Builder getCdnUrl(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object prefix = DungeonHubClient.Companion.getCdnUrl();
        CharSequence charSequence = (CharSequence)prefix;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            prefix = DungeonHubClient.Companion.getApiUrl() + "cdn/";
        }
        return HttpUrl.Companion.get((String)prefix + uri).newBuilder();
    }

    private final String performUpload(byte[] data, HttpUrl url) {
        RequestBody requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])data, (MediaType)MediaType.Companion.get("application/octet-stream"), (int)0, (int)0, (int)6, null);
        Request request = this.getClient().getApiRequest(url).post(requestBody).build();
        return this.executeRequest(request);
    }

    @Nullable
    public final String uploadFile(@NotNull byte[] data, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        HttpUrl url = this.getApiUrl(fileName).build();
        return this.performUpload(data, url);
    }

    @Nullable
    public final String uploadFile(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        HttpUrl url = this.getApiUrl().build();
        return this.performUpload(data, url);
    }

    @Nullable
    public final String downloadFile(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        HttpUrl url = this.getApiUrl(uri).build();
        Request request = new Request.Builder().url(url).get().build();
        return this.getClient().executeRequest(request);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lnet/dungeonhub/connection/ContentConnection$Companion;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/ContentConnection;", "<init>", "()V", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
    public static final class Companion
    implements ClientlessConnection<ContentConnection> {
        private Companion() {
        }

        @Override
        @NotNull
        public ContentConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
            Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
            return new ContentConnection(new AuthenticatedClient(authenticationProvider));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

