/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.model.carry_type.CarryTypeCreationModel;
import net.dungeonhub.model.carry_type.CarryTypeModel;
import net.dungeonhub.model.carry_type.CarryTypeUpdateModel;
import net.dungeonhub.model.discord_server.DiscordServerModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import net.dungeonhub.structure.ModuleConnection;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u0004"}, d2={"Lnet/dungeonhub/connection/CarryTypeConnection;", "Lnet/dungeonhub/structure/ModuleConnection;", "server", "", "client", "Lnet/dungeonhub/client/AuthenticatedClient;", "<init>", "(JLnet/dungeonhub/client/AuthenticatedClient;)V", "getClient", "()Lnet/dungeonhub/client/AuthenticatedClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "getById", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "id", "getByIdentifier", "identifier", "addNewCarryType", "creationModel", "Lnet/dungeonhub/model/carry_type/CarryTypeCreationModel;", "updateCarryType", "updateModel", "Lnet/dungeonhub/model/carry_type/CarryTypeUpdateModel;", "deleteCarryType", "carryTypeModel", "allCarryTypes", "", "getAllCarryTypes", "()Ljava/util/List;", "Companion"})
@SourceDebugExtension(value={"SMAP\nCarryTypeConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CarryTypeConnection.kt\nnet/dungeonhub/connection/CarryTypeConnection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,102:1\n295#2,2:103\n29#3:105\n*S KotlinDebug\n*F\n+ 1 CarryTypeConnection.kt\nnet/dungeonhub/connection/CarryTypeConnection\n*L\n34#1:103,2\n82#1:105\n*E\n"})
public final class CarryTypeConnection
implements ModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticatedClient client;
    @NotNull
    private final String moduleApiPrefix;
    @NotNull
    private static final Map<Long, Companion.ClientlessCarryTypeConnection> instances = new HashMap();

    public CarryTypeConnection(long server, @NotNull AuthenticatedClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "server/" + server + "/carry-type";
    }

    @Override
    @NotNull
    public AuthenticatedClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final CarryTypeModel getById(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = this.getApiRequest(url).get().build();
        return (CarryTypeModel)Connection.executeRequest$default(this, request, null, CarryTypeConnection::getById$lambda$0, 2, null);
    }

    @Nullable
    public final CarryTypeModel getByIdentifier(@Nullable String identifier) {
        CarryTypeModel carryTypeModel;
        List<CarryTypeModel> list = this.getAllCarryTypes();
        if (list != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CarryTypeModel carryTypeModel2 = (CarryTypeModel)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)carryTypeModel2.getIdentifier(), (String)identifier, (boolean)true)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            carryTypeModel = v1;
        } else {
            carryTypeModel = null;
        }
        return carryTypeModel;
    }

    @Nullable
    public final CarryTypeModel addNewCarryType(@NotNull CarryTypeCreationModel creationModel) {
        Intrinsics.checkNotNullParameter((Object)creationModel, (String)"creationModel");
        HttpUrl url = this.getApiUrl().build();
        RequestBody requestBody = RequestBody.Companion.create(creationModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).post(requestBody).build();
        return (CarryTypeModel)Connection.executeRequest$default(this, request, null, CarryTypeConnection::addNewCarryType$lambda$2, 2, null);
    }

    @Nullable
    public final CarryTypeModel updateCarryType(long id, @NotNull CarryTypeUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl(id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        return (CarryTypeModel)Connection.executeRequest$default(this, request, null, CarryTypeConnection::updateCarryType$lambda$3, 2, null);
    }

    @Nullable
    public final CarryTypeModel deleteCarryType(@NotNull CarryTypeModel carryTypeModel) {
        Intrinsics.checkNotNullParameter((Object)carryTypeModel, (String)"carryTypeModel");
        HttpUrl url = this.getApiUrl(carryTypeModel.getId()).build();
        Request request = Request.Builder.delete$default((Request.Builder)this.getApiRequest(url), null, (int)1, null).build();
        return (CarryTypeModel)Connection.executeRequest$default(this, request, null, CarryTypeConnection::deleteCarryType$lambda$4, 2, null);
    }

    @Nullable
    public final List<CarryTypeModel> getAllCarryTypes() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryTypeModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<CarryTypeModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<CarryTypeModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<CarryTypeModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    private static final CarryTypeModel getById$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTypeModel.Companion.fromJson(json);
    }

    private static final CarryTypeModel addNewCarryType$lambda$2(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTypeModel.Companion.fromJson(json);
    }

    private static final CarryTypeModel updateCarryType$lambda$3(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTypeModel.Companion.fromJson(json);
    }

    private static final CarryTypeModel deleteCarryType$lambda$4(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTypeModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0086\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/connection/CarryTypeConnection$Companion;", "", "<init>", "()V", "instances", "", "", "Lnet/dungeonhub/connection/CarryTypeConnection$Companion$ClientlessCarryTypeConnection;", "get", "server", "Lnet/dungeonhub/model/discord_server/DiscordServerModel;", "ClientlessCarryTypeConnection", "client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientlessCarryTypeConnection get(long server) {
            ClientlessCarryTypeConnection clientlessCarryTypeConnection = instances.computeIfAbsent(server, arg_0 -> Companion.get$lambda$1(Companion::get$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)clientlessCarryTypeConnection, (String)"computeIfAbsent(...)");
            return clientlessCarryTypeConnection;
        }

        @NotNull
        public final ClientlessCarryTypeConnection get(@NotNull DiscordServerModel server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return this.get(server.getId());
        }

        private static final ClientlessCarryTypeConnection get$lambda$0(Long it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ClientlessCarryTypeConnection(it);
        }

        private static final ClientlessCarryTypeConnection get$lambda$1(Function1 $tmp0, Object p0) {
            return (ClientlessCarryTypeConnection)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/connection/CarryTypeConnection$Companion$ClientlessCarryTypeConnection;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/CarryTypeConnection;", "server", "", "<init>", "(J)V", "getServer", "()J", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
        public static final class ClientlessCarryTypeConnection
        implements ClientlessConnection<CarryTypeConnection> {
            private final long server;

            public ClientlessCarryTypeConnection(long server) {
                this.server = server;
            }

            public final long getServer() {
                return this.server;
            }

            @Override
            @NotNull
            public CarryTypeConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
                Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
                return new CarryTypeConnection(this.server, new AuthenticatedClient(authenticationProvider));
            }
        }
    }
}

