/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.model.carry_tier.CarryTierCreationModel;
import net.dungeonhub.model.carry_tier.CarryTierModel;
import net.dungeonhub.model.carry_tier.CarryTierUpdateModel;
import net.dungeonhub.model.carry_type.CarryTypeModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import net.dungeonhub.structure.ModuleConnection;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0004"}, d2={"Lnet/dungeonhub/connection/CarryTierConnection;", "Lnet/dungeonhub/structure/ModuleConnection;", "carryTypeModel", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "client", "Lnet/dungeonhub/client/AuthenticatedClient;", "<init>", "(Lnet/dungeonhub/model/carry_type/CarryTypeModel;Lnet/dungeonhub/client/AuthenticatedClient;)V", "getClient", "()Lnet/dungeonhub/client/AuthenticatedClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "getByIdentifier", "Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "identifier", "allCarryTiers", "", "getAllCarryTiers", "()Ljava/util/List;", "createCarryTier", "creationModel", "Lnet/dungeonhub/model/carry_tier/CarryTierCreationModel;", "updateCarryTier", "id", "", "updateModel", "Lnet/dungeonhub/model/carry_tier/CarryTierUpdateModel;", "deleteCarryTier", "Companion"})
@SourceDebugExtension(value={"SMAP\nCarryTierConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CarryTierConnection.kt\nnet/dungeonhub/connection/CarryTierConnection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,97:1\n295#2,2:98\n29#3:100\n*S KotlinDebug\n*F\n+ 1 CarryTierConnection.kt\nnet/dungeonhub/connection/CarryTierConnection\n*L\n24#1:98,2\n47#1:100\n*E\n"})
public final class CarryTierConnection
implements ModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticatedClient client;
    @NotNull
    private final String moduleApiPrefix;
    @NotNull
    private static final Map<CarryTypeModel, Companion.ClientlessCarryTierConnection> instances = new HashMap();

    public CarryTierConnection(@NotNull CarryTypeModel carryTypeModel, @NotNull AuthenticatedClient client) {
        Intrinsics.checkNotNullParameter((Object)carryTypeModel, (String)"carryTypeModel");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "server/" + carryTypeModel.getServer().getId() + "/carry-type/" + carryTypeModel.getId() + "/carry-tier";
    }

    @Override
    @NotNull
    public AuthenticatedClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final CarryTierModel getByIdentifier(@Nullable String identifier) {
        CarryTierModel carryTierModel;
        List<CarryTierModel> list = this.getAllCarryTiers();
        if (list != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CarryTierModel carryTierModel2 = (CarryTierModel)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)carryTierModel2.getIdentifier(), (String)identifier, (boolean)true)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            carryTierModel = v1;
        } else {
            carryTierModel = null;
        }
        return carryTierModel;
    }

    @Nullable
    public final List<CarryTierModel> getAllCarryTiers() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryTierModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<CarryTierModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<CarryTierModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<CarryTierModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final CarryTierModel createCarryTier(@NotNull CarryTierCreationModel creationModel) {
        Intrinsics.checkNotNullParameter((Object)creationModel, (String)"creationModel");
        HttpUrl url = this.getApiUrl().build();
        RequestBody requestBody = RequestBody.Companion.create(creationModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).post(requestBody).build();
        return (CarryTierModel)Connection.executeRequest$default(this, request, null, CarryTierConnection::createCarryTier$lambda$1, 2, null);
    }

    @Nullable
    public final CarryTierModel updateCarryTier(long id, @NotNull CarryTierUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl(id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        return (CarryTierModel)Connection.executeRequest$default(this, request, null, CarryTierConnection::updateCarryTier$lambda$2, 2, null);
    }

    @Nullable
    public final CarryTierModel deleteCarryTier(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = Request.Builder.delete$default((Request.Builder)this.getApiRequest(url), null, (int)1, null).build();
        return (CarryTierModel)Connection.executeRequest$default(this, request, null, CarryTierConnection::deleteCarryTier$lambda$3, 2, null);
    }

    private static final CarryTierModel createCarryTier$lambda$1(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTierModel.Companion.fromJson(json);
    }

    private static final CarryTierModel updateCarryTier$lambda$2(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTierModel.Companion.fromJson(json);
    }

    private static final CarryTierModel deleteCarryTier$lambda$3(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryTierModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/dungeonhub/connection/CarryTierConnection$Companion;", "", "<init>", "()V", "instances", "", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "Lnet/dungeonhub/connection/CarryTierConnection$Companion$ClientlessCarryTierConnection;", "get", "carryTypeModel", "ClientlessCarryTierConnection", "client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientlessCarryTierConnection get(@NotNull CarryTypeModel carryTypeModel) {
            Intrinsics.checkNotNullParameter((Object)carryTypeModel, (String)"carryTypeModel");
            ClientlessCarryTierConnection clientlessCarryTierConnection = instances.computeIfAbsent(carryTypeModel, arg_0 -> Companion.get$lambda$1(Companion::get$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)clientlessCarryTierConnection, (String)"computeIfAbsent(...)");
            return clientlessCarryTierConnection;
        }

        private static final ClientlessCarryTierConnection get$lambda$0(CarryTypeModel it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ClientlessCarryTierConnection(it);
        }

        private static final ClientlessCarryTierConnection get$lambda$1(Function1 $tmp0, Object p0) {
            return (ClientlessCarryTierConnection)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/connection/CarryTierConnection$Companion$ClientlessCarryTierConnection;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/CarryTierConnection;", "carryTypeModel", "Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "<init>", "(Lnet/dungeonhub/model/carry_type/CarryTypeModel;)V", "getCarryTypeModel", "()Lnet/dungeonhub/model/carry_type/CarryTypeModel;", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
        public static final class ClientlessCarryTierConnection
        implements ClientlessConnection<CarryTierConnection> {
            @NotNull
            private final CarryTypeModel carryTypeModel;

            public ClientlessCarryTierConnection(@NotNull CarryTypeModel carryTypeModel) {
                Intrinsics.checkNotNullParameter((Object)carryTypeModel, (String)"carryTypeModel");
                this.carryTypeModel = carryTypeModel;
            }

            @NotNull
            public final CarryTypeModel getCarryTypeModel() {
                return this.carryTypeModel;
            }

            @Override
            @NotNull
            public CarryTierConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
                Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
                return new CarryTierConnection(this.carryTypeModel, new AuthenticatedClient(authenticationProvider));
            }
        }
    }
}

