/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.model.carry_difficulty.CarryDifficultyCreationModel;
import net.dungeonhub.model.carry_difficulty.CarryDifficultyModel;
import net.dungeonhub.model.carry_difficulty.CarryDifficultyUpdateModel;
import net.dungeonhub.model.carry_tier.CarryTierModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import net.dungeonhub.structure.ModuleConnection;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0004"}, d2={"Lnet/dungeonhub/connection/CarryDifficultyConnection;", "Lnet/dungeonhub/structure/ModuleConnection;", "carryTierModel", "Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "client", "Lnet/dungeonhub/client/AuthenticatedClient;", "<init>", "(Lnet/dungeonhub/model/carry_tier/CarryTierModel;Lnet/dungeonhub/client/AuthenticatedClient;)V", "getClient", "()Lnet/dungeonhub/client/AuthenticatedClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "getCarryDifficulty", "Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;", "id", "", "allCarryDifficulties", "", "getAllCarryDifficulties", "()Ljava/util/List;", "getByIdentifier", "identifier", "createCarryDifficulty", "creationModel", "Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyCreationModel;", "updateCarryDifficulty", "updateModel", "Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyUpdateModel;", "deleteCarryDifficulty", "Companion"})
@SourceDebugExtension(value={"SMAP\nCarryDifficultyConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CarryDifficultyConnection.kt\nnet/dungeonhub/connection/CarryDifficultyConnection\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n29#2:98\n295#3,2:99\n*S KotlinDebug\n*F\n+ 1 CarryDifficultyConnection.kt\nnet/dungeonhub/connection/CarryDifficultyConnection\n*L\n43#1:98\n47#1:99,2\n*E\n"})
public final class CarryDifficultyConnection
implements ModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticatedClient client;
    @NotNull
    private final String moduleApiPrefix;
    @NotNull
    private static final Map<CarryTierModel, Companion.ClientlessCarryDifficultyConnection> instances = new HashMap();

    public CarryDifficultyConnection(@NotNull CarryTierModel carryTierModel, @NotNull AuthenticatedClient client) {
        Intrinsics.checkNotNullParameter((Object)carryTierModel, (String)"carryTierModel");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "server/" + carryTierModel.getCarryType().getServer().getId() + "/carry-type/" + carryTierModel.getCarryType().getId() + "/carry-tier/" + carryTierModel.getId() + "/carry-difficulty";
    }

    @Override
    @NotNull
    public AuthenticatedClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final CarryDifficultyModel getCarryDifficulty(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = this.getApiRequest(url).get().build();
        return (CarryDifficultyModel)Connection.executeRequest$default(this, request, null, CarryDifficultyConnection::getCarryDifficulty$lambda$0, 2, null);
    }

    @Nullable
    public final List<CarryDifficultyModel> getAllCarryDifficulties() {
        HttpUrl url = this.getApiUrl("all").build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryDifficultyModel.class))));
        return (List)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<List<CarryDifficultyModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<List<CarryDifficultyModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<CarryDifficultyModel> apply(String p0) {
                return (List)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final CarryDifficultyModel getByIdentifier(@Nullable String identifier) {
        CarryDifficultyModel carryDifficultyModel;
        List<CarryDifficultyModel> list = this.getAllCarryDifficulties();
        if (list != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CarryDifficultyModel it = (CarryDifficultyModel)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getIdentifier(), (String)identifier, (boolean)true)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            carryDifficultyModel = v1;
        } else {
            carryDifficultyModel = null;
        }
        return carryDifficultyModel;
    }

    @Nullable
    public final CarryDifficultyModel createCarryDifficulty(@NotNull CarryDifficultyCreationModel creationModel) {
        Intrinsics.checkNotNullParameter((Object)creationModel, (String)"creationModel");
        HttpUrl url = this.getApiUrl().build();
        RequestBody requestBody = RequestBody.Companion.create(creationModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).post(requestBody).build();
        return (CarryDifficultyModel)Connection.executeRequest$default(this, request, null, CarryDifficultyConnection::createCarryDifficulty$lambda$2, 2, null);
    }

    @Nullable
    public final CarryDifficultyModel updateCarryDifficulty(long id, @NotNull CarryDifficultyUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl(id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        return (CarryDifficultyModel)Connection.executeRequest$default(this, request, null, CarryDifficultyConnection::updateCarryDifficulty$lambda$3, 2, null);
    }

    @Nullable
    public final CarryDifficultyModel deleteCarryDifficulty(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = Request.Builder.delete$default((Request.Builder)this.getApiRequest(url), null, (int)1, null).build();
        return (CarryDifficultyModel)Connection.executeRequest$default(this, request, null, CarryDifficultyConnection::deleteCarryDifficulty$lambda$4, 2, null);
    }

    private static final CarryDifficultyModel getCarryDifficulty$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryDifficultyModel.Companion.fromJson(json);
    }

    private static final CarryDifficultyModel createCarryDifficulty$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CarryDifficultyModel.Companion.fromJson(it);
    }

    private static final CarryDifficultyModel updateCarryDifficulty$lambda$3(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryDifficultyModel.Companion.fromJson(json);
    }

    private static final CarryDifficultyModel deleteCarryDifficulty$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CarryDifficultyModel.Companion.fromJson(it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0086\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/dungeonhub/connection/CarryDifficultyConnection$Companion;", "", "<init>", "()V", "instances", "", "Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "Lnet/dungeonhub/connection/CarryDifficultyConnection$Companion$ClientlessCarryDifficultyConnection;", "get", "carryTierModel", "ClientlessCarryDifficultyConnection", "client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientlessCarryDifficultyConnection get(@NotNull CarryTierModel carryTierModel) {
            Intrinsics.checkNotNullParameter((Object)carryTierModel, (String)"carryTierModel");
            ClientlessCarryDifficultyConnection clientlessCarryDifficultyConnection = instances.computeIfAbsent(carryTierModel, arg_0 -> Companion.get$lambda$1(Companion::get$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)clientlessCarryDifficultyConnection, (String)"computeIfAbsent(...)");
            return clientlessCarryDifficultyConnection;
        }

        private static final ClientlessCarryDifficultyConnection get$lambda$0(CarryTierModel it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ClientlessCarryDifficultyConnection(it);
        }

        private static final ClientlessCarryDifficultyConnection get$lambda$1(Function1 $tmp0, Object p0) {
            return (ClientlessCarryDifficultyConnection)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/connection/CarryDifficultyConnection$Companion$ClientlessCarryDifficultyConnection;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/CarryDifficultyConnection;", "carryTierModel", "Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "<init>", "(Lnet/dungeonhub/model/carry_tier/CarryTierModel;)V", "getCarryTierModel", "()Lnet/dungeonhub/model/carry_tier/CarryTierModel;", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
        public static final class ClientlessCarryDifficultyConnection
        implements ClientlessConnection<CarryDifficultyConnection> {
            @NotNull
            private final CarryTierModel carryTierModel;

            public ClientlessCarryDifficultyConnection(@NotNull CarryTierModel carryTierModel) {
                Intrinsics.checkNotNullParameter((Object)carryTierModel, (String)"carryTierModel");
                this.carryTierModel = carryTierModel;
            }

            @NotNull
            public final CarryTierModel getCarryTierModel() {
                return this.carryTierModel;
            }

            @Override
            @NotNull
            public CarryDifficultyConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
                Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
                return new CarryDifficultyConnection(this.carryTierModel, new AuthenticatedClient(authenticationProvider));
            }
        }
    }
}

