/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.dungeonhub.providers.HttpClientProvider;
import net.dungeonhub.structure.MappingFunction;
import net.dungeonhub.structure.RequestResult;
import net.dungeonhub.structure.StringResult;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u0001H\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002H\t0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u000fR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lnet/dungeonhub/client/DungeonHubClient;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "executeRequest", "T", "request", "Lokhttp3/Request;", "notFoundFallback", "function", "Lnet/dungeonhub/structure/MappingFunction;", "", "(Lokhttp3/Request;Ljava/lang/Object;Lnet/dungeonhub/structure/MappingFunction;)Ljava/lang/Object;", "executeRawRequest", "Lnet/dungeonhub/structure/RequestResult;", "getBody", "getApiRequest", "Lokhttp3/Request$Builder;", "uri", "httpUrl", "Lokhttp3/HttpUrl;", "getApiUrl", "Lokhttp3/HttpUrl$Builder;", "Companion", "client"})
@SourceDebugExtension(value={"SMAP\nDungeonHubClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonHubClient.kt\nnet/dungeonhub/client/DungeonHubClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public class DungeonHubClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LoggerFactory.getLogger(DungeonHubClient.class);
    @NotNull
    private static final String API_PREFIX = "api/v1/";
    @Nullable
    private static String apiUrl = System.getenv("DHAPI_URL");
    @Nullable
    private static String cdnUrl = System.getenv("DHAPI_CDN_URL");
    @Nullable
    private static String staticUrl = System.getenv("DHAPI_STATIC_URL");

    @Nullable
    public final <T> T executeRequest(@NotNull Request request, @Nullable T notFoundFallback, @NotNull MappingFunction<String, T> function) {
        T t;
        StringResult result;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        RequestResult requestResult = this.executeRawRequest(request);
        StringResult stringResult = result = requestResult != null ? requestResult.getStringResult() : null;
        boolean bl = stringResult != null ? stringResult.getCode() == 404 : false;
        if (bl && result.getResult() == null) {
            return notFoundFallback;
        }
        Object object = result;
        if (object != null && (object = ((StringResult)object).getResult()) != null) {
            Object it = object;
            boolean bl2 = false;
            t = function.apply((String)it);
        } else {
            t = null;
        }
        return t;
    }

    public static /* synthetic */ Object executeRequest$default(DungeonHubClient dungeonHubClient, Request request, Object object, MappingFunction mappingFunction, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeRequest");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        return dungeonHubClient.executeRequest(request, object, mappingFunction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final RequestResult executeRawRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            Closeable closeable = (Closeable)HttpClientProvider.INSTANCE.getHttpClient().newCall(request).execute();
            Throwable throwable = null;
            try {
                byte[] bytes;
                Response response = (Response)closeable;
                boolean bl = false;
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    byte[] byArray;
                    ResponseBody it = responseBody;
                    boolean bl2 = false;
                    try {
                        byArray = it.bytes();
                    }
                    catch (IOException ioException) {
                        this.logger.error(null, (Throwable)ioException);
                        byArray = null;
                    }
                    v1 = byArray;
                } else {
                    v1 = bytes = null;
                }
                if (response.isSuccessful()) {
                    this.logger.debug("Executed request to '{}' successfully.", (Object)request.url());
                } else if (response.code() == 404) {
                    this.logger.debug("Executed request to '{}' returned a 404.", (Object)request.url());
                } else {
                    String string;
                    String body = this.getBody(request);
                    Logger logger = this.logger;
                    String string2 = "Request to '{}' wasn't successful. Body:\n{}\nResponse: {}\n{}";
                    Object[] objectArray = new Object[4];
                    objectArray[0] = request.url();
                    objectArray[1] = body;
                    objectArray[2] = response.code();
                    Object[] objectArray2 = objectArray;
                    int n = 3;
                    if (response.body() != null) {
                        if (bytes != null) {
                            void it;
                            byte[] bl2 = bytes;
                            int n2 = n;
                            Object[] objectArray3 = objectArray2;
                            String string3 = string2;
                            Logger logger2 = logger;
                            boolean bl3 = false;
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                            Charset charset2 = charset;
                            String string4 = new String((byte[])it, charset2);
                            logger = logger2;
                            string2 = string3;
                            objectArray2 = objectArray3;
                            n = n2;
                            string = string4;
                        } else {
                            string = null;
                        }
                    } else {
                        string = null;
                    }
                    objectArray2[n] = string;
                    logger.error(string2, objectArray);
                }
                RequestResult requestResult = new RequestResult(response.code(), !(bytes != null ? !(bytes.length == 0) : false) ? null : bytes);
                return requestResult;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ioException) {
            this.logger.error(null, (Throwable)ioException);
            return null;
        }
    }

    @Nullable
    public final String executeRequest(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = this.executeRawRequest(request);
        return object != null && (object = ((RequestResult)object).getStringResult()) != null ? ((StringResult)object).getSuccessResult() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getBody(Request request) {
        Request newRequest = request.newBuilder().build();
        if (newRequest.body() == null) {
            return null;
        }
        try {
            Closeable closeable = (Closeable)new Buffer();
            Throwable throwable = null;
            try {
                Buffer buffer = (Buffer)closeable;
                boolean bl = false;
                RequestBody requestBody = newRequest.body();
                Intrinsics.checkNotNull((Object)requestBody);
                requestBody.writeTo((BufferedSink)buffer);
                String string = buffer.readUtf8();
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    @NotNull
    public final Request.Builder getApiRequest(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.getApiRequest(this.getApiUrl(uri).build());
    }

    @NotNull
    public Request.Builder getApiRequest(@NotNull HttpUrl httpUrl) {
        Intrinsics.checkNotNullParameter((Object)httpUrl, (String)"httpUrl");
        MediaType mediaType = MediaType.Companion.get("multipart/form-data; boundary=---011000010111000001101001");
        return new Request.Builder().url(httpUrl).addHeader("Content-Type", mediaType.toString());
    }

    @NotNull
    public final HttpUrl.Builder getApiUrl(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return HttpUrl.Companion.get(apiUrl + API_PREFIX + uri).newBuilder();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lnet/dungeonhub/client/DungeonHubClient$Companion;", "", "<init>", "()V", "API_PREFIX", "", "apiUrl", "getApiUrl", "()Ljava/lang/String;", "setApiUrl", "(Ljava/lang/String;)V", "cdnUrl", "getCdnUrl", "setCdnUrl", "staticUrl", "getStaticUrl", "setStaticUrl", "client"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getApiUrl() {
            return apiUrl;
        }

        public final void setApiUrl(@Nullable String string) {
            apiUrl = string;
        }

        @Nullable
        public final String getCdnUrl() {
            return cdnUrl;
        }

        public final void setCdnUrl(@Nullable String string) {
            cdnUrl = string;
        }

        @Nullable
        public final String getStaticUrl() {
            return staticUrl;
        }

        public final void setStaticUrl(@Nullable String string) {
            staticUrl = string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

