/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.auth;

import com.squareup.moshi.Json;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.dungeonhub.auth.AuthenticationCredentials;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.model.auth.JwtTokenModel;
import net.dungeonhub.providers.HttpClientProvider;
import net.dungeonhub.service.MoshiService;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lnet/dungeonhub/auth/AuthenticationConnection;", "Lnet/dungeonhub/auth/AuthenticationProvider;", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "jwtToken", "Lnet/dungeonhub/model/auth/JwtTokenModel;", "apiToken", "", "getApiToken", "()Ljava/lang/String;", "loadToken", "LoginResponse", "client"})
public final class AuthenticationConnection
implements AuthenticationProvider {
    @NotNull
    public static final AuthenticationConnection INSTANCE = new AuthenticationConnection();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static JwtTokenModel jwtToken;

    private AuthenticationConnection() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    @Override
    @NotNull
    public synchronized String getApiToken() {
        if (jwtToken.validUntil().isBefore(Instant.now())) {
            jwtToken = this.loadToken();
        }
        return jwtToken.token();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public final synchronized JwtTokenModel loadToken() {
        v0 = new FormBody.Builder(null, 1, null).add("grant_type", "client_credentials");
        v1 = AuthenticationCredentials.INSTANCE.getClientId();
        Intrinsics.checkNotNull((Object)v1);
        v2 = v0.add("client_id", v1);
        v3 = AuthenticationCredentials.INSTANCE.getClientSecret();
        Intrinsics.checkNotNull((Object)v3);
        requestBody = v2.add("client_secret", v3).build();
        v4 = new Request.Builder();
        v5 = AuthenticationCredentials.INSTANCE.getAuthLoginUrl();
        Intrinsics.checkNotNull((Object)v5);
        request = v4.url(v5).post((RequestBody)requestBody).build();
        try {
            var5_3 = (Closeable)HttpClientProvider.INSTANCE.getHttpClient().newCall(request).execute();
            var6_4 = null;
            try {
                block14: {
                    block13: {
                        response = (Response)var5_3;
                        $i$a$-use-AuthenticationConnection$loadToken$responseBody$1 = false;
                        if (!response.isSuccessful()) break block13;
                        var9_11 = response.body();
                        if (var9_11 == null) ** GOTO lbl-1000
                        body = var9_11;
                        $i$a$-let-AuthenticationConnection$loadToken$responseBody$1$1 = false;
                        try {
                            var12_14 = body.bytes();
                        }
                        catch (IOException <unused var>) {
                            var12_14 = null;
                        }
                        var14_17 = var12_14;
                        if (var14_17 != null) {
                            bytes = var14_17;
                            $i$a$-let-AuthenticationConnection$loadToken$responseBody$1$2 = false;
                            var12_14 = bytes;
                            v6 = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"UTF_8");
                            var13_16 = v6;
                            v7 = new String(var12_14, var13_16);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v7 = null;
                        }
                        break block14;
                    }
                    v7 = null;
                }
                response = v7;
            }
            catch (Throwable var8_9) {
                var6_4 = var8_9;
                throw var8_9;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var5_3, (Throwable)var6_4);
            }
            var5_3 = response;
        }
        catch (IOException ioException) {
            AuthenticationConnection.logger.error(null, (Throwable)ioException);
            var5_3 = null;
        }
        v8 = var5_3;
        if (v8 == null) {
            throw new IllegalStateException("Could not load token");
        }
        responseBody = v8;
        v9 = MoshiService.INSTANCE.getMoshi().adapter(LoginResponse.class).fromJson((String)responseBody);
        Intrinsics.checkNotNull((Object)v9);
        response = (LoginResponse)v9;
        token = response.getAccessToken();
        expiresIn = response.getExpiresIn();
        validUntil = Instant.now().plusSeconds(expiresIn);
        Intrinsics.checkNotNull((Object)validUntil);
        return new JwtTokenModel(token, validUntil);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AuthenticationConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        AuthenticationConnection.logger = logger;
        jwtToken = INSTANCE.loadToken();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/dungeonhub/auth/AuthenticationConnection$LoginResponse;", "", "accessToken", "", "expiresIn", "", "<init>", "(Ljava/lang/String;I)V", "getAccessToken", "()Ljava/lang/String;", "getExpiresIn", "()I", "client"})
    public static final class LoginResponse {
        @NotNull
        private final String accessToken;
        private final int expiresIn;

        public LoginResponse(@Json(name="access_token") @NotNull String accessToken, @Json(name="expires_in") int expiresIn) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            this.accessToken = accessToken;
            this.expiresIn = expiresIn;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        public final int getExpiresIn() {
            return this.expiresIn;
        }
    }
}

