/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonhub.connection;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.util.Set;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import net.dungeonhub.auth.AuthenticationProvider;
import net.dungeonhub.client.AuthenticatedClient;
import net.dungeonhub.client.DungeonHubClient;
import net.dungeonhub.enums.QueueStep;
import net.dungeonhub.model.carry_difficulty.CarryDifficultyModel;
import net.dungeonhub.model.carry_queue.CarryQueueCreationModel;
import net.dungeonhub.model.carry_queue.CarryQueueModel;
import net.dungeonhub.model.carry_queue.CarryQueueUpdateModel;
import net.dungeonhub.model.score.LoggedCarryModel;
import net.dungeonhub.service.MoshiService;
import net.dungeonhub.structure.AuthenticatedModuleConnection;
import net.dungeonhub.structure.ClientlessConnection;
import net.dungeonhub.structure.Connection;
import net.dungeonhub.structure.MappingFunction;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u0015J\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u0017J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0015J\u0018\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0002"}, d2={"Lnet/dungeonhub/connection/QueueConnection;", "Lnet/dungeonhub/structure/AuthenticatedModuleConnection;", "client", "Lnet/dungeonhub/client/DungeonHubClient;", "<init>", "(Lnet/dungeonhub/client/DungeonHubClient;)V", "getClient", "()Lnet/dungeonhub/client/DungeonHubClient;", "moduleApiPrefix", "", "getModuleApiPrefix", "()Ljava/lang/String;", "addNewQueue", "Lnet/dungeonhub/model/carry_queue/CarryQueueModel;", "carryDifficultyModel", "Lnet/dungeonhub/model/carry_difficulty/CarryDifficultyModel;", "creationModel", "Lnet/dungeonhub/model/carry_queue/CarryQueueCreationModel;", "getCarryQueueByRelatedIdAndQueueStep", "", "relatedId", "", "queueStep", "Lnet/dungeonhub/enums/QueueStep;", "getCarryQueueByRelatedId", "id", "getCarryQueuesByQueueStep", "step", "updateQueue", "updateModel", "Lnet/dungeonhub/model/carry_queue/CarryQueueUpdateModel;", "deleteQueue", "", "logQueue", "Lnet/dungeonhub/model/score/LoggedCarryModel;", "Companion"})
@SourceDebugExtension(value={"SMAP\nQueueConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueueConnection.kt\nnet/dungeonhub/connection/QueueConnection\n+ 2 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,122:1\n29#2:123\n29#2:124\n29#2:125\n*S KotlinDebug\n*F\n+ 1 QueueConnection.kt\nnet/dungeonhub/connection/QueueConnection\n*L\n53#1:123\n65#1:124\n77#1:125\n*E\n"})
public final class QueueConnection
extends AuthenticatedModuleConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DungeonHubClient client;
    @NotNull
    private final String moduleApiPrefix;

    public QueueConnection(@NotNull DungeonHubClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
        this.moduleApiPrefix = "queue";
    }

    @Override
    @NotNull
    public DungeonHubClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public String getModuleApiPrefix() {
        return this.moduleApiPrefix;
    }

    @Nullable
    public final CarryQueueModel addNewQueue(@NotNull CarryDifficultyModel carryDifficultyModel, @NotNull CarryQueueCreationModel creationModel) {
        Intrinsics.checkNotNullParameter((Object)carryDifficultyModel, (String)"carryDifficultyModel");
        Intrinsics.checkNotNullParameter((Object)creationModel, (String)"creationModel");
        HttpUrl url = this.getApiUrl("carry-difficulty/" + carryDifficultyModel.getId()).build();
        RequestBody requestBody = RequestBody.Companion.create(creationModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).post(requestBody).build();
        return (CarryQueueModel)Connection.executeRequest$default(this, request, null, QueueConnection::addNewQueue$lambda$0, 2, null);
    }

    @Nullable
    public final Set<CarryQueueModel> getCarryQueueByRelatedIdAndQueueStep(long relatedId, @NotNull QueueStep queueStep) {
        Intrinsics.checkNotNullParameter((Object)queueStep, (String)"queueStep");
        HttpUrl url = this.getApiUrl("all").addQueryParameter("related-id", String.valueOf(relatedId)).addQueryParameter("queue-step", queueStep.name()).build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(Set.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryQueueModel.class))));
        return (Set)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<Set<CarryQueueModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<Set<CarryQueueModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Set<CarryQueueModel> apply(String p0) {
                return (Set)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final Set<CarryQueueModel> getCarryQueueByRelatedId(long id) {
        HttpUrl url = this.getApiUrl("all").addQueryParameter("related-id", String.valueOf(id)).build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(Set.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryQueueModel.class))));
        return (Set)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<Set<CarryQueueModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<Set<CarryQueueModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Set<CarryQueueModel> apply(String p0) {
                return (Set)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final Set<CarryQueueModel> getCarryQueuesByQueueStep(@NotNull QueueStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        HttpUrl url = this.getApiUrl("all").addQueryParameter("queue-step", step.name()).build();
        Request request = this.getApiRequest(url).get().build();
        Moshi $this$adapter$iv = MoshiService.INSTANCE.getMoshi();
        boolean $i$f$adapter = false;
        JsonAdapter jsonAdapter = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, (KType)Reflection.typeOf(Set.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CarryQueueModel.class))));
        return (Set)Connection.executeRequest$default(this, request, null, new MappingFunction((JsonAdapter<Set<CarryQueueModel>>)jsonAdapter){
            final /* synthetic */ JsonAdapter<Set<CarryQueueModel>> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Set<CarryQueueModel> apply(String p0) {
                return (Set)this.$tmp0.fromJson(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, JsonAdapter.class, "fromJson", "fromJson(Ljava/lang/String;)Ljava/lang/Object;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof MappingFunction ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }, 2, null);
    }

    @Nullable
    public final CarryQueueModel updateQueue(long id, @NotNull CarryQueueUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl(id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).put(requestBody).build();
        return (CarryQueueModel)Connection.executeRequest$default(this, request, null, QueueConnection::updateQueue$lambda$1, 2, null);
    }

    public final boolean deleteQueue(long id) {
        HttpUrl url = this.getApiUrl(id).build();
        Request request = Request.Builder.delete$default((Request.Builder)this.getApiRequest(url), null, (int)1, null).build();
        return this.executeRequest(request) != null;
    }

    @Nullable
    public final LoggedCarryModel logQueue(long id, @NotNull CarryQueueUpdateModel updateModel) {
        Intrinsics.checkNotNullParameter((Object)updateModel, (String)"updateModel");
        HttpUrl url = this.getApiUrl("log/" + id).build();
        RequestBody requestBody = RequestBody.Companion.create(updateModel.toJson(), this.getJsonMediaType());
        Request request = this.getApiRequest(url).post(requestBody).build();
        return (LoggedCarryModel)Connection.executeRequest$default(this, request, null, QueueConnection::logQueue$lambda$2, 2, null);
    }

    private static final CarryQueueModel addNewQueue$lambda$0(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryQueueModel.Companion.fromJson(json);
    }

    private static final CarryQueueModel updateQueue$lambda$1(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return CarryQueueModel.Companion.fromJson(json);
    }

    private static final LoggedCarryModel logQueue$lambda$2(String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return LoggedCarryModel.Companion.fromJson(json);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lnet/dungeonhub/connection/QueueConnection$Companion;", "Lnet/dungeonhub/structure/ClientlessConnection;", "Lnet/dungeonhub/connection/QueueConnection;", "<init>", "()V", "authenticated", "authenticationProvider", "Lnet/dungeonhub/auth/AuthenticationProvider;", "client"})
    public static final class Companion
    implements ClientlessConnection<QueueConnection> {
        private Companion() {
        }

        @Override
        @NotNull
        public QueueConnection authenticated(@NotNull AuthenticationProvider authenticationProvider) {
            Intrinsics.checkNotNullParameter((Object)authenticationProvider, (String)"authenticationProvider");
            return new QueueConnection(new AuthenticatedClient(authenticationProvider));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

