/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.onejarloader;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class OneJarLoader
extends ClassLoader {
    public static final String SYSPROP_LOGGER_PREFIX = "OneJarLoader.";
    private final Logger loggerJar = this.initLogger("Jar");
    private final Logger loggerClass = this.initLogger("Class");
    private final Logger loggerNative = this.initLogger("Native");
    private final Logger loggerResource = this.initLogger("Resource");
    private final List<JarFileInfo> jarFiles;
    private final Map<File, Closeable> filesDeleteOnExit = new LinkedHashMap<File, Closeable>();
    final Path tmpDir;
    final ConcurrentHashMap<String, Path> registeredFiles = new ConcurrentHashMap();

    public OneJarLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public OneJarLoader(ClassLoader parent) {
        super(parent);
        try {
            this.tmpDir = Files.createTempDirectory("OneJarLoader-", new FileAttribute[0]);
            this.tmpDir.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new OneJarLoaderException(e);
        }
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL topJarUrl = codeSource.getLocation();
        String protocol = topJarUrl.getProtocol();
        if ("file".equals(protocol)) {
            String mainJarUrl;
            try {
                mainJarUrl = URLDecoder.decode(topJarUrl.getFile(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new UncheckedIOException(e);
            }
            File fileJar = new File(mainJarUrl);
            if (fileJar.isDirectory()) {
                List files;
                this.loggerJar.info("Launched from exploded directory: directory=%s", mainJarUrl);
                try {
                    files = Files.walk(fileJar.toPath(), 1, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".jar")).peek(p -> this.registeredFiles.put(p.getFileName().toString(), (Path)p)).map(p -> p.toFile()).sorted().collect(Collectors.toList());
                }
                catch (IOException e) {
                    throw new OneJarLoaderException("Failed to list directory: directory=" + mainJarUrl + " : " + e.getMessage(), e);
                }
                this.jarFiles = files.stream().map(file -> this.loadFileJar(null, (File)file)).collect(Collectors.toList()).stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toList());
            } else {
                JarFile jarFile;
                this.loggerJar.info("Launched from single jar: file=%s", mainJarUrl);
                this.registeredFiles.put(fileJar.getName(), fileJar.toPath());
                try {
                    jarFile = new JarFile(fileJar);
                }
                catch (IOException ex) {
                    throw new OneJarLoaderException("Failed to open top JarFile: " + fileJar, ex);
                }
                JarFileInfo jarFileInfo = this.createJarFileInfoFromParent(null, fileJar.getAbsolutePath(), topJarUrl, jarFile, null);
                this.jarFiles = this.traverseJarFile(jarFileInfo).join();
            }
        } else {
            throw new OneJarLoaderException("Unsupported protocol for jar: protocol=" + protocol);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
        this.logShadows();
        if (this.loggerJar.isEnabled(Logger.Level.INFO)) {
            this.loggerJar.info("Loaded jars: %s", this.jarFiles.stream().map(jfi -> jfi.fullPath).collect(Collectors.joining(" ")));
        }
    }

    public void invokeMain(String className, String[] args) throws Exception {
        Thread.getAllStackTraces().keySet().forEach(t -> {
            try {
                t.setContextClassLoader(this);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        });
        Class<?> clazz = this.loadClass(className);
        this.loggerClass.info("Executing main: classLoader=%s class=%s", clazz.getClassLoader(), className);
        Method method = clazz.getMethod("main", String[].class);
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers) || method.getReturnType() != Void.TYPE) {
            throw new NoSuchMethodException("The main() method in class is not public static void: " + method);
        }
        method.invoke(null, new Object[]{args});
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        List urls = this.findJarEntries(name).stream().map(inf -> inf.getURL()).filter(Objects::nonNull).collect(Collectors.toList());
        if (!urls.isEmpty()) {
            return Collections.enumeration(urls);
        }
        return super.findResources(name);
    }

    @Override
    protected URL findResource(String name) {
        JarEntryInfo inf = this.findJarEntry(name);
        if (inf != null) {
            URL url = inf.getURL();
            this.loggerResource.debug("Found resource: %s", url);
            return url;
        }
        return super.findResource(name);
    }

    @Override
    protected String findLibrary(String name) {
        Map.Entry<String, JarEntryInfo> inf = this.findJarNativeEntry(name);
        if (inf != null) {
            try {
                Map.Entry<Path, Boolean> file = this.copyToTempFile(inf.getValue(), inf.getKey());
                if (file.getValue().booleanValue()) {
                    this.loggerNative.debug("Loading native library: name=%s file=%s", inf.getValue().jarEntry, file);
                    this.filesDeleteOnExit.put(file.getKey().toFile(), () -> {});
                }
                return file.getKey().toAbsolutePath().toString();
            }
            catch (IOException e) {
                throw new OneJarLoaderException(String.format("Failure to load native library %s: %s", name, e), e);
            }
        }
        return super.findLibrary(name);
    }

    private Logger initLogger(String sub) {
        Logger.Level logLevel = Optional.ofNullable(System.getProperty(SYSPROP_LOGGER_PREFIX + sub + ".level")).map(Logger.Level::valueOf).orElse(Logger.Level.ERROR);
        return new Logger(SYSPROP_LOGGER_PREFIX + sub, logLevel, System.err);
    }

    private Map.Entry<Path, Boolean> copyToTempFile(final JarEntryInfo inf, String name) throws IOException {
        String realName = name == null ? inf.getBaseName() : name;
        final Path resolved = this.tmpDir.resolve(realName);
        final AbstractMap.SimpleEntry<Path, Boolean> ret = new AbstractMap.SimpleEntry<Path, Boolean>(resolved, false);
        this.registeredFiles.computeIfAbsent(realName, new Function<String, Path>(){

            @Override
            public Path apply(String key) {
                try (InputStream input = inf.getInputStream();
                     OutputStream output = Files.newOutputStream(resolved, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    int read;
                    byte[] buffer = new byte[262144];
                    while ((read = input.read(buffer)) > 0) {
                        output.write(buffer, 0, read);
                    }
                }
                ret.setValue(true);
                return resolved;
            }
        });
        return ret;
    }

    private CompletableFuture<List<JarFileInfo>> loadFileJar(JarFileInfo parent, File file) {
        return CompletableFuture.supplyAsync(this.sneakySupplier(() -> {
            JarFile jarFile = new JarFile(file);
            JarFileInfo jarFileInfo = this.createJarFileInfoFromParent(parent, file.getAbsolutePath(), file.toURI().toURL(), jarFile, null);
            return jarFileInfo;
        })).thenCompose(jarFileInfo -> this.traverseJarFile((JarFileInfo)jarFileInfo).thenApply(l -> {
            l.add(0, jarFileInfo);
            return l;
        }));
    }

    private CompletableFuture<List<JarFileInfo>> loadNestedJar(JarFileInfo parent, JarEntryInfo inf) {
        return CompletableFuture.supplyAsync(this.sneakySupplier(() -> {
            Map.Entry<Path, Boolean> tmp = this.copyToTempFile(inf, null);
            if (!tmp.getValue().booleanValue()) {
                return null;
            }
            File file = tmp.getKey().toFile();
            this.loggerJar.info("Loading inner JAR from temp file: jar=%s temp=%s", inf.jarEntry, file);
            URL url = file.toURI().toURL();
            JarFile jarFile = new JarFile(file);
            return this.createJarFileInfoFromParent(parent, file.getAbsolutePath(), url, jarFile, file);
        })).thenCompose(jarFileInfo -> jarFileInfo == null ? CompletableFuture.completedFuture(Collections.emptyList()) : this.traverseJarFile((JarFileInfo)jarFileInfo).thenApply(l -> {
            l.add(0, jarFileInfo);
            return l;
        }));
    }

    private CompletableFuture<List<JarFileInfo>> traverseJarFile(JarFileInfo jarFileInfo) {
        ArrayList<CompletableFuture<List<JarFileInfo>>> children = new ArrayList<CompletableFuture<List<JarFileInfo>>>();
        Enumeration<JarEntry> en = jarFileInfo.jarFile.entries();
        String EXT_JAR = ".jar";
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".jar")) continue;
            this.loggerJar.info("Found nested jar file: %s", entry.getName());
            JarEntryInfo inf = new JarEntryInfo(jarFileInfo, entry);
            children.add(this.loadNestedJar(jarFileInfo, inf));
        }
        return CompletableFuture.allOf(children.toArray(new CompletableFuture[children.size()])).thenApply(v -> children.stream().flatMap(future -> ((List)future.join()).stream()).collect(Collectors.toList()));
    }

    private JarFileInfo createJarFileInfoFromParent(JarFileInfo parent, String entryPath, URL url, JarFile jarFile, File file) {
        ProtectionDomain pdParent = parent != null ? parent.protectionDomain : this.getClass().getProtectionDomain();
        CodeSource csParent = pdParent.getCodeSource();
        Certificate[] certParent = csParent.getCertificates();
        CodeSource csChild = certParent == null ? new CodeSource(url, csParent.getCodeSigners()) : new CodeSource(url, certParent);
        ProtectionDomain pdChild = new ProtectionDomain(csChild, pdParent.getPermissions(), pdParent.getClassLoader(), pdParent.getPrincipals());
        return new JarFileInfo(jarFile, parent, entryPath, pdChild, file);
    }

    private JarEntryInfo findJarEntry(String name) {
        return this.jarFiles.stream().map(jarFile -> Optional.ofNullable(jarFile.jarFile.getJarEntry(name)).map(entry -> new JarEntryInfo((JarFileInfo)jarFile, (JarEntry)entry)).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private List<JarEntryInfo> findJarEntries(String name) {
        return this.jarFiles.stream().map(jarFile -> Optional.ofNullable(jarFile.jarFile.getJarEntry(name)).map(entry -> new JarEntryInfo((JarFileInfo)jarFile, (JarEntry)entry)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map.Entry<String, JarEntryInfo> findJarNativeEntry(String library) {
        String sysName = System.mapLibraryName(library);
        String fullPath = System.getProperty("os.name") + "/" + System.getProperty("os.arch") + "/" + sysName;
        JarEntryInfo entry = this.findJarEntry(fullPath);
        if (entry == null) {
            entry = this.findJarEntry(sysName);
        }
        if (entry == null) {
            return null;
        }
        this.loggerNative.debug("Loading native library: library=%s jar=%s full=%s", library, entry.jarFileInfo.fullPath, entry.jarEntry.getName());
        return new AbstractMap.SimpleImmutableEntry<String, JarEntryInfo>(sysName, entry);
    }

    private Class<?> findJarClass(String className) throws IOException {
        Class<?> clazz = null;
        String path = className.replace('.', '/') + ".class";
        JarEntryInfo entry = this.findJarEntry(path);
        if (entry != null) {
            byte[] content = entry.getContent();
            this.definePackage(className, entry);
            try {
                clazz = this.defineClass(className, content, 0, content.length, entry.jarFileInfo.protectionDomain);
                this.loggerClass.debug("Loaded class: name=%s loaded=%s jar=%s", className, this.getClass().getName(), entry.jarFileInfo.fullPath);
            }
            catch (ClassFormatError e) {
                throw new OneJarLoaderException(null, e);
            }
        }
        return clazz;
    }

    private void logShadows() {
        if (!this.loggerJar.isEnabled(Logger.Level.WARN)) {
            return;
        }
        HashSet<String> ignore = new HashSet<String>();
        ignore.add("module-info.class");
        ignore.add("license.txt");
        ignore.add("notice.txt");
        HashMap present = new HashMap();
        for (JarFileInfo jarFileInfo : this.jarFiles) {
            JarFile jarFile = jarFileInfo.jarFile;
            jarFile.stream().filter(entry -> !entry.isDirectory()).map(ZipEntry::getName).filter(name -> !name.startsWith("META-INF/")).filter(name -> !ignore.contains(name)).forEach(name -> present.compute(name, (key, old) -> {
                if (old != null) {
                    this.loggerJar.warn("Entry shadowed: entry=%s hidden=%s main=%s", name, jarFileInfo.fullPath, old.fullPath);
                    return old;
                }
                return jarFileInfo;
            }));
        }
    }

    private void shutdown() {
        this.loggerJar.info("Shutting down", new Object[0]);
        Iterator<Object> it = this.jarFiles.listIterator(this.jarFiles.size());
        while (it.hasPrevious()) {
            JarFileInfo jarFileInfo = it.previous();
            File file = jarFileInfo.fileDeleteOnExit;
            if (file == null || file.delete()) continue;
            this.filesDeleteOnExit.put(file, jarFileInfo.jarFile);
        }
        if (!this.filesDeleteOnExit.isEmpty()) {
            Map.Entry entry;
            it = this.filesDeleteOnExit.entrySet().iterator();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                try {
                    ((Closeable)entry.getValue()).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!((File)entry.getKey()).delete()) continue;
                it.remove();
            }
            System.gc();
            System.gc();
            it = this.filesDeleteOnExit.entrySet().iterator();
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                if (((File)entry.getKey()).delete()) {
                    it.remove();
                    continue;
                }
                ((File)entry.getKey()).deleteOnExit();
            }
        }
        this.loggerJar.info("Completed cleanup", new Object[0]);
    }

    @Override
    protected synchronized Class<?> findClass(String clazzName) throws ClassNotFoundException {
        Class<?> c;
        this.loggerClass.debug("Loading class: class=%s", clazzName);
        try {
            c = this.findJarClass(clazzName);
            if (c != null) {
                this.loggerClass.info("Loaded class: requested=%s loaded=%s", clazzName, c);
                return c;
            }
        }
        catch (IOException ex) {
            throw new OneJarLoaderException(String.format("Error loading class: class=%s loaders=%s : %s", clazzName, this.getClass().getName(), ex.getCause()), ex);
        }
        ClassLoader cl = this.getParent();
        c = cl.loadClass(clazzName);
        return c;
    }

    private void definePackage(String className, JarEntryInfo entry) throws IllegalArgumentException {
        int lastDot = className.lastIndexOf(46);
        String packageName = lastDot > 0 ? className.substring(0, lastDot) : "";
        try {
            if (this.getPackage(packageName) == null) {
                JarFileInfo jfi = entry.jarFileInfo;
                this.definePackage(packageName, jfi.getSpecificationTitle(), jfi.getSpecificationVersion(), jfi.getSpecificationVendor(), jfi.getImplementationTitle(), jfi.getImplementationVersion(), jfi.getImplementationVendor(), jfi.getSealURL());
            }
        }
        catch (Throwable ex) {
            this.loggerClass.error("Failed to create package: jar=%s package=%s class=%s : %s", entry.jarFileInfo.fullPath, packageName, className, ex);
        }
    }

    private <X extends Throwable> RuntimeException sneakyThrow(X ex) {
        throw ex;
    }

    private <R> Supplier<R> sneakySupplier(Callable<R> callable) {
        return () -> {
            try {
                return callable.call();
            }
            catch (Exception ex) {
                throw this.sneakyThrow(ex);
            }
        };
    }

    public static class Logger {
        private final String name;
        private final Level configuredLevel;
        private final PrintStream output;

        public boolean isEnabled(Level level) {
            return level.ordinal() <= this.configuredLevel.ordinal();
        }

        public void trace(String format, Object ... args) {
            this.log(Level.DEBUG, format, args);
        }

        public void debug(String format, Object ... args) {
            this.log(Level.DEBUG, format, args);
        }

        public void info(String format, Object ... args) {
            this.log(Level.INFO, format, args);
        }

        public void warn(String format, Object ... args) {
            this.log(Level.WARN, format, args);
        }

        public void error(String format, Object ... args) {
            this.log(Level.ERROR, format, args);
        }

        public void log(Level level, String format, Object ... args) {
            if (this.isEnabled(level)) {
                this.output.printf(this.name + "-" + (Object)((Object)level) + ": " + format + "\n", args);
            }
        }

        public Logger(String name, Level configuredLevel, PrintStream output) {
            this.name = name;
            this.configuredLevel = configuredLevel;
            this.output = output;
        }

        public static enum Level {
            OFF,
            ERROR,
            WARN,
            INFO,
            DEBUG,
            TRACE;

        }
    }

    private static class OneJarLoaderException
    extends RuntimeException {
        OneJarLoaderException(String message) {
            super(message);
        }

        OneJarLoaderException(String message, Throwable cause) {
            super(message, cause);
        }

        OneJarLoaderException(Throwable cause) {
            super(cause);
        }
    }

    private static class JarFileInfo {
        final JarFile jarFile;
        final String fsPath;
        final String fullPath;
        final File fileDeleteOnExit;
        final Manifest manifest;
        final ProtectionDomain protectionDomain;
        final String rootPath;
        final URL rootUrl;

        JarFileInfo(final JarFile jarFile, JarFileInfo jarFileParent, String entryPath, ProtectionDomain protectionDomain, File deleteOnExit) {
            this.jarFile = jarFile;
            this.fsPath = jarFile.getName();
            this.fullPath = (jarFileParent != null ? jarFileParent.fullPath + "!" : "") + entryPath;
            this.protectionDomain = protectionDomain;
            this.fileDeleteOnExit = deleteOnExit;
            Manifest manifest = null;
            try {
                manifest = jarFile.getManifest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (manifest == null) {
                manifest = new Manifest();
            }
            this.manifest = manifest;
            this.rootPath = "jar:file:" + this.fullPath + "!/";
            try {
                this.rootUrl = new URL(null, this.rootPath, new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL url) throws IOException {
                        String str = url.toExternalForm();
                        if (!str.startsWith(rootPath)) {
                            throw new IOException("Url does not belong to jar file: url=" + str + " jar=" + rootPath);
                        }
                        String relative = str.substring(rootPath.length());
                        final JarEntry entry = jarFile.getJarEntry(relative);
                        if (entry == null) {
                            throw new FileNotFoundException("Requested file not found: " + str);
                        }
                        return new URLConnection(url){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return jarFile.getInputStream(entry);
                            }
                        };
                    }
                });
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }

        String getSpecificationTitle() {
            return this.manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_TITLE);
        }

        String getSpecificationVersion() {
            return this.manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        }

        String getSpecificationVendor() {
            return this.manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VENDOR);
        }

        String getImplementationTitle() {
            return this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        }

        String getImplementationVersion() {
            return this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        }

        String getImplementationVendor() {
            return this.manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }

        URL getSealURL() {
            String seal = this.manifest.getMainAttributes().getValue(Attributes.Name.SEALED);
            if (seal != null) {
                try {
                    return new URL(seal);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return null;
        }

        public String getFullPath() {
            return this.fullPath;
        }
    }

    static class JarEntryInfo {
        final JarFileInfo jarFileInfo;
        final JarEntry jarEntry;

        URL getURL() {
            try {
                return new URL(this.jarFileInfo.rootUrl, this.jarEntry.getName());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }

        String getBaseName() {
            String name = this.jarEntry.getName();
            int lastSlash = name.lastIndexOf(47);
            return lastSlash >= 0 ? name.substring(lastSlash) : name;
        }

        public String toString() {
            return "JAR=" + this.jarFileInfo.jarFile.getName() + " ENTRY=" + this.jarEntry;
        }

        byte[] getContent() throws IOException {
            long size = this.jarEntry.getSize();
            if (size > Integer.MAX_VALUE) {
                throw new IOException("Entry exceeds max allowed size of Integer.MAX_VALUE: entry=" + this.jarEntry + " size=" + size);
            }
            byte[] content = new byte[(int)size];
            try (InputStream input = this.getInputStream();){
                int read;
                for (int off = 0; off < content.length; off += read) {
                    read = input.read(content, off, content.length - off);
                    if (read > 0) continue;
                    throw new IOException("Jar entry stream ended prematurely: entry=" + this.jarEntry + " expected=" + content.length + " ended=" + off);
                }
            }
            return content;
        }

        InputStream getInputStream() throws IOException {
            return this.jarFileInfo.jarFile.getInputStream(this.jarEntry);
        }

        public JarEntryInfo(JarFileInfo jarFileInfo, JarEntry jarEntry) {
            this.jarFileInfo = jarFileInfo;
            this.jarEntry = jarEntry;
        }
    }
}

