/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.provider;

import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import net.dryuf.netty.core.NettyEngine;
import net.dryuf.netty.provider.ChannelProvider;

public class NioChannelProvider
implements ChannelProvider {
    @Override
    public EventLoopGroup createBossEventLoopGroup() {
        return new NioEventLoopGroup(1);
    }

    @Override
    public EventLoopGroup createWorkerEventLoopGroup() {
        return new NioEventLoopGroup(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public EventLoopGroup createEventLoopGroup(int threads) {
        return new NioEventLoopGroup(threads);
    }

    @Override
    public SocketAddress convertAddress(SocketAddress original) {
        if (original instanceof DomainSocketAddress) {
            return UnixDomainSocketAddress.of(((DomainSocketAddress)original).path());
        }
        return original;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> getServerChannel(String proto, SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return () -> NettyEngine.isProtoNeutral(proto) ? new NioServerSocketChannel(SelectorProvider.provider()) : new NioServerSocketChannel(SelectorProvider.provider(), NettyEngine.getNettyProtocolByAddress(((InetSocketAddress)address).getAddress()));
        }
        if (address instanceof UnixDomainSocketAddress || address instanceof DomainSocketAddress) {
            return () -> new NioServerSocketChannel((SelectorProvider)new DelegatedSelectorProvider(SelectorProvider.provider()){

                @Override
                public ServerSocketChannel openServerSocketChannel() throws IOException {
                    StandardProtocolFamily protocol = StandardProtocolFamily.UNIX;
                    return super.openServerSocketChannel(protocol);
                }
            });
        }
        throw new UnsupportedOperationException("Unsupported socket address: class=" + String.valueOf(address.getClass()));
    }

    @Override
    public ChannelFactory<? extends DuplexChannel> getStreamChannel(final String proto, final SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return () -> new NioSocketChannel((SelectorProvider)new DelegatedSelectorProvider(SelectorProvider.provider()){

                @Override
                public SocketChannel openSocketChannel() throws IOException {
                    ProtocolFamily protocol = NettyEngine.getProtocolByAddress(((InetSocketAddress)address).getAddress());
                    return NettyEngine.isProtoNeutral(proto) ? super.openSocketChannel() : super.openSocketChannel(protocol);
                }
            });
        }
        if (address instanceof UnixDomainSocketAddress || address instanceof DomainSocketAddress) {
            return () -> new NioSocketChannel((SelectorProvider)new DelegatedSelectorProvider(SelectorProvider.provider()){

                @Override
                public ServerSocketChannel openServerSocketChannel() throws IOException {
                    StandardProtocolFamily protocol = StandardProtocolFamily.UNIX;
                    return super.openServerSocketChannel(protocol);
                }
            });
        }
        throw new UnsupportedOperationException("Unsupported socket address: class=" + String.valueOf(address.getClass()));
    }

    @Override
    public ChannelFactory<? extends io.netty.channel.socket.DatagramChannel> getDatagramChannel(final String proto, final SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return () -> new NioDatagramChannel((SelectorProvider)new DelegatedSelectorProvider(SelectorProvider.provider()){

                @Override
                public DatagramChannel openDatagramChannel() throws IOException {
                    ProtocolFamily protocol = NettyEngine.getProtocolByAddress(((InetSocketAddress)address).getAddress());
                    return NettyEngine.isProtoNeutral(proto) ? super.openDatagramChannel() : super.openDatagramChannel(protocol);
                }
            });
        }
        if (address instanceof UnixDomainSocketAddress || address instanceof DomainSocketAddress) {
            return () -> new NioDatagramChannel((SelectorProvider)new DelegatedSelectorProvider(SelectorProvider.provider()){

                @Override
                public DatagramChannel openDatagramChannel() throws IOException {
                    StandardProtocolFamily protocol = StandardProtocolFamily.UNIX;
                    return super.openDatagramChannel(protocol);
                }
            });
        }
        return NioDatagramChannel::new;
    }

    public static class DelegatedSelectorProvider
    extends SelectorProvider {
        private final SelectorProvider delegate;

        public DelegatedSelectorProvider(SelectorProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public DatagramChannel openDatagramChannel() throws IOException {
            return this.delegate.openDatagramChannel();
        }

        @Override
        public DatagramChannel openDatagramChannel(ProtocolFamily arg0) throws IOException {
            return this.delegate.openDatagramChannel(arg0);
        }

        @Override
        public Pipe openPipe() throws IOException {
            return this.delegate.openPipe();
        }

        @Override
        public AbstractSelector openSelector() throws IOException {
            return this.delegate.openSelector();
        }

        @Override
        public ServerSocketChannel openServerSocketChannel() throws IOException {
            return this.delegate.openServerSocketChannel();
        }

        @Override
        public SocketChannel openSocketChannel() throws IOException {
            return this.delegate.openSocketChannel();
        }

        @Override
        public Channel inheritedChannel() throws IOException {
            return this.delegate.inheritedChannel();
        }

        @Override
        public SocketChannel openSocketChannel(ProtocolFamily family) throws IOException {
            return this.delegate.openSocketChannel(family);
        }

        @Override
        public ServerSocketChannel openServerSocketChannel(ProtocolFamily family) throws IOException {
            return this.delegate.openServerSocketChannel(family);
        }
    }
}

