/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;

public class CumulatingByteBufHandler
extends ChannelDuplexHandler {
    private final int maxLength;
    protected final ByteBuf accumulator = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer());
    private ChannelConfig config;
    private boolean shouldConsume = false;
    private boolean needMore = true;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.config = ctx.channel().config();
        super.handlerAdded(ctx);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        if (this.needMore || this.dequeue(ctx, 1) == 0) {
            this.shouldConsume = true;
            ctx.read();
        } else if (this.config.isAutoRead()) {
            ctx.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf input = (ByteBuf)msg;
        try {
            this.accumulator.writeBytes(input);
        }
        finally {
            ReferenceCountUtil.release((Object)input);
        }
        this.needMore = false;
        this.dequeue(ctx, this.shouldConsume ? 1 : 0);
        if (this.accumulator.readableBytes() > this.maxLength) {
            throw new IllegalStateException("Too much unconsumed data received from client: length=" + this.accumulator.readableBytes() + " client=" + String.valueOf(ctx.channel()));
        }
    }

    private int dequeue(ChannelHandlerContext ctx, int minConsume) {
        int consumed;
        int lastRead = this.accumulator.readerIndex();
        for (consumed = 0; consumed < minConsume || this.config.isAutoRead(); ++consumed) {
            this.needMore = true;
            ctx.fireChannelRead((Object)this.accumulator);
            int newRead = this.accumulator.readerIndex();
            if (newRead == lastRead) break;
            lastRead = newRead;
            this.needMore = false;
        }
        if (consumed != 0) {
            this.accumulator.discardReadBytes();
        }
        return consumed;
    }

    public CumulatingByteBufHandler(int maxLength) {
        this.maxLength = maxLength;
    }
}

