/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.test.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CompletableFuture;

public class ExpectDataHandler
extends ChannelInboundHandlerAdapter {
    private final CompletableFuture<Object> finished;
    private final Object expected;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
        super.handlerAdded(ctx);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try {
            if (msg.equals(this.expected)) {
                this.finished.complete(this.expected);
                ReferenceCountUtil.touch((Object)msg);
                ctx.writeAndFlush(msg).addListener(f -> ctx.close());
            } else {
                ctx.read();
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.finished.completeExceptionally(cause);
        super.exceptionCaught(ctx, cause);
    }

    public ExpectDataHandler(CompletableFuture<Object> finished, Object expected) {
        this.finished = finished;
        this.expected = expected;
    }
}

