/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class CumulatingCharBufferHandler
extends ChannelDuplexHandler {
    private final int maxLength;
    private final CharsetDecoder decoder;
    private final ByteBuffer nioAccumulator = ByteBuffer.allocate(64);
    protected CharBuffer accumulator = CharBuffer.allocate(4);
    private ChannelConfig config;
    private boolean shouldConsume = false;
    private boolean needMore = true;

    public CumulatingCharBufferHandler(CharsetDecoder decoder, int maxLength) {
        this.decoder = decoder;
        this.maxLength = maxLength;
    }

    public CumulatingCharBufferHandler(Charset charset, int maxLength) {
        this(charset.newDecoder(), maxLength);
    }

    public CumulatingCharBufferHandler(int maxLength) {
        this(StandardCharsets.UTF_8, maxLength);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.config = ctx.channel().config();
        super.handlerAdded(ctx);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        if (this.needMore || this.dequeue(ctx, 1) == 0) {
            this.shouldConsume = true;
            ctx.read();
        } else if (this.config.isAutoRead()) {
            ctx.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf input = (ByteBuf)msg;
        try {
            while (true) {
                this.nioAccumulator.limit(Math.min(this.nioAccumulator.capacity(), input.readableBytes() + this.nioAccumulator.position()));
                input.readBytes(this.nioAccumulator);
                this.nioAccumulator.flip();
                try {
                    CoderResult result = this.decoder.decode(this.nioAccumulator, this.accumulator, false);
                    if (result.isOverflow()) {
                        CharBuffer newAccumulator = CharBuffer.allocate(this.accumulator.capacity() * 2);
                        this.accumulator.flip();
                        newAccumulator.put(this.accumulator);
                        this.accumulator = newAccumulator;
                        continue;
                    }
                    if (result.isUnderflow()) {
                        if (input.readableBytes() != 0) continue;
                        break;
                    }
                    if (!result.isError()) continue;
                    throw new IOException("Failed to map input bytes: error=" + String.valueOf(result));
                }
                finally {
                    this.nioAccumulator.compact();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to translate bytes input into a string", e);
        }
        finally {
            ReferenceCountUtil.release((Object)input);
        }
        this.needMore = false;
        this.dequeue(ctx, this.shouldConsume ? 1 : 0);
        if (this.accumulator.position() > this.maxLength) {
            throw new IllegalStateException("Too much unconsumed data received from client: length=" + this.accumulator.position() + " client=" + String.valueOf(ctx.channel()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dequeue(ChannelHandlerContext ctx, int minConsume) {
        this.accumulator.flip();
        try {
            int consumed;
            int lastRead = this.accumulator.remaining();
            for (consumed = 0; consumed < minConsume || this.config.isAutoRead(); ++consumed) {
                this.needMore = true;
                ctx.fireChannelRead((Object)this.accumulator);
                int newRead = this.accumulator.remaining();
                if (newRead == lastRead) break;
                lastRead = newRead;
                this.needMore = false;
            }
            int n = consumed;
            return n;
        }
        finally {
            this.accumulator.compact();
        }
    }
}

