/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.core;

import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface Server
extends AutoCloseable {
    public CompletableFuture<Void> closedFuture();

    public SocketAddress listenAddress();

    public CompletableFuture<Void> cancel();

    @Override
    public void close();

    public static CompletableFuture<Void> waitOneAndClose(final List<? extends Server> servers) {
        return new CompletableFuture<Void>(){
            {
                servers.forEach(s -> s.closedFuture().whenCompleteAsync((v, ex) -> this.closeAll((Throwable)ex)));
            }

            private synchronized void closeAll(Throwable ex) {
                servers.forEach(s -> s.close());
                if (ex != null) {
                    this.completeExceptionally(ex);
                } else {
                    this.complete(null);
                }
            }
        };
    }
}

