/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.test;

import com.google.common.base.Stopwatch;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.DuplexChannel;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.dryuf.netty.core.NettyEngine;
import net.dryuf.netty.core.Server;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientServerTester
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger(ClientServerTester.class);
    public static final long RUN_LENGTH = 2000L;
    private final NettyEngine nettyEngine;
    private final List<Server> servers = new ArrayList<Server>();

    public ClientServerTester() {
        this(new NettyEngine());
    }

    public ClientServerTester(NettyEngine nettyEngine) {
        this.nettyEngine = nettyEngine;
    }

    public void addServer(Server server) {
        this.servers.add(server);
    }

    public double runClientLoop(final TestConfig config, final Function<NettyEngine, CompletableFuture<Void>> runClient) {
        final long started = System.currentTimeMillis();
        Stopwatch stopwatch = Stopwatch.createStarted();
        final AtomicInteger counter = new AtomicInteger(0);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 2 * 1 + 1; ++i) {
            Function<Void, CompletableFuture<Void>> code = new Function<Void, CompletableFuture<Void>>(){

                @Override
                public CompletableFuture<Void> apply(Void v) {
                    if (System.currentTimeMillis() - started >= config.getRunLength()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    counter.incrementAndGet();
                    return ((CompletableFuture)runClient.apply(ClientServerTester.this.nettyEngine)).thenComposeAsync((Function)this);
                }
            };
            CompletionStage future = CompletableFuture.completedFuture(null).thenComposeAsync(code);
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        double performance = (double)counter.get() * 1.0E9 * (double)config.getBatchSize() / (double)stopwatch.elapsed(TimeUnit.NANOSECONDS);
        log.info("Performance: time={} count={} ops/s={}", (Object)stopwatch.toString(), (Object)(counter.get() * config.getBatchSize()), (Object)performance);
        return performance;
    }

    public <T extends DuplexChannel> double runNettyClientLoop(TestConfig config, final SocketAddress connectAddress, final Function<CompletableFuture<Void>, ChannelInitializer<T>> clientInitializer, final Function<DuplexChannel, ? extends CompletionStage<Void>> runner) {
        return this.runClientLoop(config, runtime -> new CompletableFuture<Void>(){
            {
                ClientServerTester.this.nettyEngine.connect("tcp4", connectAddress, (ChannelHandler)clientInitializer.apply(this)).thenCompose(runner);
            }
        });
    }

    @Override
    public void close() {
        this.servers.forEach(s -> s.close());
    }

    public NettyEngine nettyEngine() {
        return this.nettyEngine;
    }

    public static final class TestConfig {
        public static TestConfig DEFAULT = TestConfig.builder().build();
        private final int batchSize;
        private final long runLength;

        private static int $default$batchSize() {
            return 1;
        }

        private static long $default$runLength() {
            return 2000L;
        }

        TestConfig(int batchSize, long runLength) {
            this.batchSize = batchSize;
            this.runLength = runLength;
        }

        public static TestConfigBuilder builder() {
            return new TestConfigBuilder();
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public long getRunLength() {
            return this.runLength;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestConfig)) {
                return false;
            }
            TestConfig other = (TestConfig)o;
            if (this.getBatchSize() != other.getBatchSize()) {
                return false;
            }
            return this.getRunLength() == other.getRunLength();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getBatchSize();
            long $runLength = this.getRunLength();
            result = result * 59 + (int)($runLength >>> 32 ^ $runLength);
            return result;
        }

        public String toString() {
            return "ClientServerTester.TestConfig(batchSize=" + this.getBatchSize() + ", runLength=" + this.getRunLength() + ")";
        }

        public static class TestConfigBuilder {
            private boolean batchSize$set;
            private int batchSize$value;
            private boolean runLength$set;
            private long runLength$value;

            TestConfigBuilder() {
            }

            public TestConfigBuilder batchSize(int batchSize) {
                this.batchSize$value = batchSize;
                this.batchSize$set = true;
                return this;
            }

            public TestConfigBuilder runLength(long runLength) {
                this.runLength$value = runLength;
                this.runLength$set = true;
                return this;
            }

            public TestConfig build() {
                int batchSize$value = this.batchSize$value;
                if (!this.batchSize$set) {
                    batchSize$value = TestConfig.$default$batchSize();
                }
                long runLength$value = this.runLength$value;
                if (!this.runLength$set) {
                    runLength$value = TestConfig.$default$runLength();
                }
                return new TestConfig(batchSize$value, runLength$value);
            }

            public String toString() {
                return "ClientServerTester.TestConfig.TestConfigBuilder(batchSize$value=" + this.batchSize$value + ", runLength$value=" + this.runLength$value + ")";
            }
        }
    }
}

