/*
 * Decompiled with CFR 0.152.
 */
package net.dryuf.netty.core;

import com.google.common.collect.ImmutableMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.resolver.InetNameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.dryuf.concurrent.FutureUtil;
import net.dryuf.netty.address.AddressSpec;
import net.dryuf.netty.pipeline.ForwarderHandler;
import net.dryuf.netty.provider.ChannelProvider;
import net.dryuf.netty.provider.EpollChannelProvider;
import net.dryuf.netty.provider.KqueueChannelProvider;
import net.dryuf.netty.provider.NioChannelProvider;
import net.dryuf.netty.util.NettyFutures;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class NettyEngine
implements Closeable {
    private static final Logger log = LogManager.getLogger(NettyEngine.class);
    public static Map<String, Class<? extends InetAddress>> PROTO_TO_ADDRESS_CLASS = ImmutableMap.builder().put((Object)"udp4", Inet4Address.class).put((Object)"tcp4", Inet4Address.class).put((Object)"udp6", Inet6Address.class).put((Object)"tcp6", Inet6Address.class).put((Object)"udp", InetAddress.class).put((Object)"tcp", InetAddress.class).build();
    private ChannelProvider channelProvider;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private final InetNameResolver inetNameResolver;

    public NettyEngine(ChannelProvider channelProvider) {
        this.channelProvider = channelProvider;
        this.bossGroup = channelProvider.createBossEventLoopGroup();
        this.workerGroup = channelProvider.createWorkerEventLoopGroup();
        this.inetNameResolver = new DnsNameResolverBuilder().eventLoop(this.workerGroup.next()).channelFactory(channelProvider.getDatagramChannel(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0))).build();
    }

    @Inject
    public NettyEngine() {
        this(NettyEngine.createChannelProvider());
    }

    public CompletableFuture<SocketAddress> resolve(final SocketAddress address) {
        if (address instanceof InetSocketAddress && ((InetSocketAddress)address).isUnresolved()) {
            InetSocketAddress address1 = (InetSocketAddress)address;
            if (address1.getHostString().equals("*")) {
                return CompletableFuture.completedFuture(new InetSocketAddress(address1.getPort()));
            }
            final Future future = this.getInetNameResolver().resolve(((InetSocketAddress)address).getHostString());
            return new CompletableFuture<SocketAddress>(){
                {
                    future.addListener(f -> {
                        try {
                            this.complete(new InetSocketAddress((InetAddress)f.get(), ((InetSocketAddress)address).getPort()));
                        }
                        catch (Throwable ex) {
                            this.completeExceptionally(ex);
                        }
                    });
                }
            };
        }
        return CompletableFuture.completedFuture(address);
    }

    private CompletableFuture<SocketAddress> resolve(final String proto, final SocketAddress address) {
        if (address instanceof InetSocketAddress && ((InetSocketAddress)address).isUnresolved()) {
            InetSocketAddress address1 = (InetSocketAddress)address;
            final String hostname = address1.getHostString();
            if (hostname.equals("*")) {
                try {
                    switch (proto) {
                        case "tcp4": 
                        case "udp4": {
                            return CompletableFuture.completedFuture(new InetSocketAddress(InetAddress.getByAddress(new byte[4]), address1.getPort()));
                        }
                        case "tcp": 
                        case "udp": 
                        case "tcp6": 
                        case "udp6": {
                            return CompletableFuture.completedFuture(new InetSocketAddress(InetAddress.getByAddress(new byte[16]), address1.getPort()));
                        }
                    }
                    throw new IllegalArgumentException("Unknown protocol: proto=" + proto);
                }
                catch (UnknownHostException ex) {
                    return CompletableFuture.failedFuture(new UnknownHostException("Failed to resolve " + hostname + " : " + ex.getMessage()));
                }
            }
            final Future future = this.getInetNameResolver().resolveAll(hostname);
            return new CompletableFuture<SocketAddress>(){
                {
                    future.addListener(f -> {
                        try {
                            Class clazz;
                            Class clazz2 = clazz = proto == null ? InetAddress.class : PROTO_TO_ADDRESS_CLASS.get(proto);
                            if (clazz == null) {
                                throw new IllegalArgumentException("Unrecognized proto: " + proto);
                            }
                            Optional<InetAddress> resolved = ((List)future.get()).stream().filter(clazz::isInstance).findFirst();
                            if (!resolved.isPresent()) {
                                throw new UnknownHostException("Unknown host for proto=" + proto + ": " + hostname);
                            }
                            this.complete(new InetSocketAddress(resolved.get(), ((InetSocketAddress)address).getPort()));
                        }
                        catch (Throwable ex) {
                            this.completeExceptionally(ex);
                        }
                    });
                }
            };
        }
        return CompletableFuture.completedFuture(address);
    }

    public CompletableFuture<ServerChannel> listen(AddressSpec addressSpec, ChannelInitializer<DuplexChannel> channelInitializer) {
        try {
            return this.listen(addressSpec.getProto(), this.getProtoAddress(addressSpec), channelInitializer);
        }
        catch (Throwable ex) {
            return FutureUtil.exception((Throwable)ex);
        }
    }

    public CompletableFuture<ServerChannel> listen(final String proto, final SocketAddress listen, final ChannelInitializer<DuplexChannel> channelInitializer) {
        try {
            return new CompletableFuture<ServerChannel>(){
                ChannelFuture bindFuture;
                {
                    ((CompletableFuture)NettyEngine.this.resolve(proto, listen).thenAccept(this::stepBind)).whenComplete((T v, U ex) -> {
                        if (ex != null) {
                            this.completeExceptionally((Throwable)ex);
                        }
                    });
                }

                private synchronized void stepBind(SocketAddress address) {
                    ServerBootstrap b = new ServerBootstrap();
                    ((ServerBootstrap)((ServerBootstrap)b.group(NettyEngine.this.bossGroup, NettyEngine.this.workerGroup).channelFactory(NettyEngine.this.channelProvider.getServerChannel(address))).option(ChannelOption.SO_BACKLOG, (Object)Integer.MAX_VALUE)).childHandler((ChannelHandler)channelInitializer).childOption(ChannelOption.AUTO_READ, (Object)false).childOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
                    if (!SystemUtils.IS_OS_MAC_OSX) {
                        b.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
                    }
                    this.bindFuture = b.bind(NettyEngine.this.channelProvider.convertAddress(address));
                    this.bindFuture.addListener(f -> {
                        try {
                            try {
                                f.get();
                            }
                            catch (ExecutionException ex) {
                                throw ex.getCause();
                            }
                            if (!this.complete((ServerChannel)this.bindFuture.channel())) {
                                this.bindFuture.channel().close();
                            }
                        }
                        catch (IOException ex) {
                            this.completeExceptionally(new UncheckedIOException("Failed to bind to: " + String.valueOf(address) + " : " + ex.getMessage(), ex));
                        }
                        catch (Throwable ex) {
                            this.completeExceptionally(new IOException("Failed to bind to: " + String.valueOf(address), ex));
                        }
                    });
                }

                @Override
                public synchronized boolean cancel(boolean interrupt) {
                    return this.bindFuture.cancel(interrupt);
                }
            };
        }
        catch (Throwable ex) {
            return FutureUtil.exception((Throwable)ex);
        }
    }

    public CompletableFuture<DuplexChannel> connect(AddressSpec addressSpec, ChannelHandler channelInitializer) {
        try {
            return this.connect(addressSpec.getProto(), this.getProtoAddress(addressSpec), channelInitializer);
        }
        catch (Throwable ex) {
            return FutureUtil.exception((Throwable)ex);
        }
    }

    public CompletableFuture<DuplexChannel> connect(final String proto, final SocketAddress address, final ChannelHandler channelInitializer) {
        return new CompletableFuture<DuplexChannel>(){
            private ChannelFuture future;
            {
                NettyEngine.this.resolve(proto, address).whenComplete((v, ex) -> {
                    if (ex != null) {
                        this.completeExceptionally((Throwable)ex);
                    } else {
                        this.stepConnect((SocketAddress)v);
                    }
                });
            }

            private synchronized void stepConnect(SocketAddress resolved) {
                SocketAddress converted = NettyEngine.this.channelProvider.convertAddress(resolved);
                if (this.isDone()) {
                    return;
                }
                try {
                    Bootstrap b = new Bootstrap();
                    this.future = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(NettyEngine.this.workerGroup)).channelFactory(NettyEngine.this.channelProvider.getStreamChannel(converted))).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true)).handler(channelInitializer)).connect(converted);
                    this.future.addListener(f -> {
                        try {
                            try {
                                f.get();
                            }
                            catch (ExecutionException ex) {
                                throw ex.getCause();
                            }
                            this.complete((DuplexChannel)this.future.channel());
                        }
                        catch (IOException ex) {
                            this.completeExceptionally(new UncheckedIOException("Failed to connect to: " + String.valueOf(address) + " : " + ex.getMessage(), ex));
                        }
                        catch (Throwable ex) {
                            this.completeExceptionally(new IOException("Failed to connect to: " + String.valueOf(address), ex));
                        }
                    });
                }
                catch (Throwable ex) {
                    this.completeExceptionally(ex);
                }
            }

            @Override
            public synchronized boolean cancel(boolean interrupt) {
                if (this.future != null) {
                    return this.future.cancel(interrupt);
                }
                return super.cancel(interrupt);
            }
        };
    }

    public CompletableFuture<Void> shutdownOutput(DuplexChannel channel) {
        return this.writeAndShutdown(channel, Unpooled.EMPTY_BUFFER);
    }

    public CompletableFuture<Void> writeAndShutdown(final DuplexChannel channel, final ByteBuf buf) {
        return new CompletableFuture<Void>(){
            {
                5 this0 = this;
                channel.writeAndFlush((Object)buf).addListener(f -> {
                    try {
                        if (f.isSuccess()) {
                            NettyFutures.copy(channel.shutdownOutput(), this0);
                        } else {
                            this.completeExceptionally(f.cause());
                        }
                    }
                    catch (Throwable ex) {
                        this.completeExceptionally(ex);
                    }
                });
            }
        };
    }

    public CompletableFuture<Void> writeAndClose(DuplexChannel channel, ByteBuf buf) {
        return FutureUtil.composeAlways(this.writeAndShutdown(channel, buf), () -> NettyFutures.toCompletable(channel.close()));
    }

    public CompletableFuture<Void> forwardUni(DuplexChannel source, DuplexChannel destination) {
        CompletableFuture<Void> clientPromise = new CompletableFuture<Void>();
        source.pipeline().addLast(new ChannelHandler[]{new ForwarderHandler(this, source, destination, clientPromise)});
        return clientPromise;
    }

    public CompletableFuture<Void> forwardDuplex(DuplexChannel source, DuplexChannel destination) {
        return FutureUtil.join(this.forwardUni(source, destination), this.forwardUni(destination, source), (boolean)true);
    }

    @Override
    public void close() throws IOException {
        this.workerGroup.shutdownGracefully().syncUninterruptibly();
        this.bossGroup.shutdownGracefully().syncUninterruptibly();
    }

    public static ProtocolFamily getProtocolByAddress(InetAddress address) {
        return address instanceof Inet6Address ? StandardProtocolFamily.INET6 : StandardProtocolFamily.INET;
    }

    public static InternetProtocolFamily getNettyProtocolByAddress(InetAddress address) {
        return address instanceof Inet6Address ? InternetProtocolFamily.IPv6 : InternetProtocolFamily.IPv4;
    }

    public static ChannelProvider createChannelProvider() {
        try {
            if (SystemUtils.IS_OS_LINUX) {
                return new EpollChannelProvider();
            }
            if (SystemUtils.IS_OS_MAC_OSX) {
                return new KqueueChannelProvider();
            }
        }
        catch (Throwable ex) {
            log.error("Cannot create expected ConfigAdapter, falling back to Nio", ex);
        }
        return new NioChannelProvider();
    }

    public SocketAddress getProtoAddress(AddressSpec addressSpec) {
        switch (addressSpec.getProto()) {
            case "tcp": 
            case "tcp4": 
            case "tcp6": 
            case "udp": 
            case "udp4": 
            case "udp6": {
                return InetSocketAddress.createUnresolved(Optional.ofNullable(addressSpec.getHost()).orElse("*"), addressSpec.getPort());
            }
            case "domain": 
            case "unix": {
                return UnixDomainSocketAddress.of(addressSpec.getPath());
            }
        }
        throw new IllegalArgumentException("Unsupported proto: " + addressSpec.getProto());
    }

    public static boolean isProtoNeutral(String proto) {
        if (proto == null) {
            return true;
        }
        switch (proto) {
            case "tcp": 
            case "udp": 
            case "domain": 
            case "unix": {
                return true;
            }
            case "tcp4": 
            case "tcp6": 
            case "udp4": 
            case "udp6": {
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected proto: proto=" + proto);
    }

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public InetNameResolver getInetNameResolver() {
        return this.inetNameResolver;
    }
}

