/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.thread.pool;

import java.util.Queue;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.thread.pool.AbstractSynRunnable;

public abstract class AbstractQueueRunnable<T>
extends AbstractSynRunnable {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueueRunnable.class);

    protected AbstractQueueRunnable(Executor executor) {
        super(executor);
    }

    public boolean addMsg(T t) {
        if (this.isCanceled()) {
            log.error("\u4efb\u52a1\u5df2\u7ecf\u53d6\u6d88");
            return false;
        }
        return this.getMsgQueue().add(t);
    }

    public void clearMsgQueue() {
        if (this.getMsgQueue() != null) {
            this.getMsgQueue().clear();
        }
    }

    @Override
    public boolean isNeededExecute() {
        return this.getMsgQueue() != null && !this.getMsgQueue().isEmpty() && !this.isCanceled();
    }

    public abstract Queue<T> getMsgQueue();

    public int getMsgQueueSize() {
        Queue<T> msgQueue = this.getMsgQueue();
        if (msgQueue == null) {
            return -1;
        }
        return msgQueue.size();
    }
}

