/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.mica;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StrTemplateParser {
    private final List<String> literals = new ArrayList<String>(4);
    private final List<String> variables = new ArrayList<String>(4);

    public StrTemplateParser(String template) {
        this.parseTemplate(template);
    }

    private void parseTemplate(String template) {
        int varStart;
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("\u6a21\u677f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int start = 0;
        int templateLength = template.length();
        while (start < templateLength && (varStart = template.indexOf("${", start)) != -1) {
            this.literals.add(template.substring(start, varStart));
            int varIdx = varStart + 2;
            int varEnd = template.indexOf(125, varIdx);
            if (varEnd == -1) {
                throw new IllegalArgumentException("\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff1a\u7f3a\u5c11\u7ed3\u675f\u7b26 '}'");
            }
            if (varEnd == varIdx) {
                throw new IllegalArgumentException("\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff1a\u53d8\u91cf\u540d\u4e3a\u7a7a");
            }
            this.variables.add(template.substring(varIdx, varEnd));
            start = varEnd + 1;
        }
        this.literals.add(template.substring(start));
    }

    public Map<String, String> getVariables(String input) {
        if (input == null || this.literals.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.variables.size());
        int pos = 0;
        if (!input.startsWith(this.literals.get(0))) {
            return Collections.emptyMap();
        }
        pos += this.literals.get(0).length();
        for (int varIdx = 0; varIdx < this.variables.size(); ++varIdx) {
            String value;
            String literal = this.literals.get(varIdx + 1);
            if (literal.isEmpty()) {
                value = input.substring(pos);
                pos = input.length();
            } else {
                int next = input.indexOf(literal, pos);
                if (next == -1) {
                    return Collections.emptyMap();
                }
                value = input.substring(pos, next);
                pos = next + literal.length();
            }
            result.put(this.variables.get(varIdx), value);
        }
        return pos == input.length() ? result : Collections.emptyMap();
    }
}

