/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.timer;

import java.util.Objects;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskList;

public class TimerTaskEntry
implements Comparable<TimerTaskEntry> {
    private volatile TimerTaskList list;
    protected TimerTaskEntry next;
    protected TimerTaskEntry prev;
    private final TimerTask timerTask;
    private final long expirationMs;

    public TimerTaskEntry(TimerTask timerTask, long expirationMs) {
        if (timerTask != null) {
            timerTask.setTimerTaskEntry(this);
        }
        this.timerTask = timerTask;
        this.expirationMs = expirationMs;
    }

    public boolean cancelled() {
        return this.timerTask.getTimerTaskEntry() != this;
    }

    public void remove() {
        TimerTaskList currentList = this.list;
        while (currentList != null) {
            currentList.remove(this);
            currentList = this.list;
        }
    }

    @Override
    public int compareTo(TimerTaskEntry that) {
        long thatExpirationMs = Objects.requireNonNull(that, (String)"Args that TimerTaskEntry is null").expirationMs;
        return Long.compare(this.expirationMs, thatExpirationMs);
    }

    public long getExpirationMs() {
        return this.expirationMs;
    }

    public TimerTask getTimerTask() {
        return this.timerTask;
    }

    public TimerTaskList getList() {
        return this.list;
    }

    public void setList(TimerTaskList list) {
        this.list = list;
    }
}

