/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.queue;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.tio.utils.queue.Mapped;

final class OffsetFile
extends Mapped {
    static final String EXTENSION = ".offset";

    OffsetFile(Path path, long pos, long size) throws IOException {
        super(path, pos, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(long pos, int size) throws IOException {
        MappedByteBuffer byteBuffer = null;
        try {
            byteBuffer = this.channel.map(FileChannel.MapMode.READ_WRITE, pos, size);
            long l = byteBuffer.getLong();
            return l;
        }
        finally {
            buffCleaner.accept(byteBuffer);
        }
    }

    void write(long offset) {
        this.buffer.putLong(offset);
    }

    long read() {
        return this.buffer.getLong();
    }
}

