/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.mica;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StrTemplateParser {
    private final List<String> literals = new ArrayList<String>(4);
    private final List<String> variables = new ArrayList<String>(4);

    public StrTemplateParser(String template) {
        this.parseTemplate(template);
    }

    private void parseTemplate(String template) {
        int varStart;
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("\u6a21\u677f\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int start = 0;
        int templateLength = template.length();
        while (start < templateLength && (varStart = template.indexOf("${", start)) != -1) {
            this.literals.add(template.substring(start, varStart));
            int varIdx = varStart + 2;
            int varEnd = template.indexOf(125, varIdx);
            if (varEnd == -1) {
                throw new IllegalArgumentException("\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff1a\u7f3a\u5c11\u7ed3\u675f\u7b26 '}'");
            }
            if (varEnd == varIdx) {
                throw new IllegalArgumentException("\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff1a\u53d8\u91cf\u540d\u4e3a\u7a7a");
            }
            this.variables.add(template.substring(varIdx, varEnd));
            start = varEnd + 1;
        }
        this.literals.add(template.substring(start));
    }

    public Map<String, String> getVariables(String input) {
        if (input == null || this.literals.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(this.variables.size());
        String firstLiteral = this.literals.get(0);
        if (!input.startsWith(firstLiteral)) {
            return Collections.emptyMap();
        }
        int currentPos = firstLiteral.length();
        int literalsSize = this.literals.size();
        for (int i = 1; i < literalsSize; ++i) {
            String literal = this.literals.get(i);
            int literalPos = input.indexOf(literal, currentPos);
            if (literalPos == -1) {
                return Collections.emptyMap();
            }
            if (literalPos > currentPos) {
                String varValue = input.substring(currentPos, literalPos);
                result.put(this.variables.get(i - 1), varValue);
            } else {
                result.put(this.variables.get(i - 1), "");
            }
            currentPos = literalPos + literal.length();
        }
        return currentPos == input.length() ? result : Collections.emptyMap();
    }
}

