/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.json;

import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.tio.utils.json.JsonAdapter;

public class HuToolJsonAdapter
implements JsonAdapter {
    public static final String CLAZZ_NAME = "cn.hutool.json.JSONUtil";
    private final JSONConfig jsonConfig;

    public HuToolJsonAdapter() {
        this(JSONConfig.create());
    }

    public HuToolJsonAdapter(JSONConfig jsonConfig) {
        this.jsonConfig = Objects.requireNonNull(jsonConfig, "HuTool json jsonConfig is null.");
    }

    @Override
    public String toJsonString(Object object) {
        return JSONUtil.toJsonStr((Object)object, (JSONConfig)this.jsonConfig);
    }

    @Override
    public <T> T readValue(String json, Class<T> clazz) {
        return (T)JSONUtil.parseObj((Object)json, (JSONConfig)this.jsonConfig).toBean(clazz);
    }

    @Override
    public <T> T readValue(String json, Type type) {
        return (T)JSONUtil.parseObj((Object)json, (JSONConfig)this.jsonConfig).toBean(type);
    }

    @Override
    public <T> List<T> readList(String json, Class<T> clazz) {
        return JSONUtil.parseArray((Object)json, (JSONConfig)this.jsonConfig).toList(clazz);
    }

    @Override
    public <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)JSONUtil.parse((Object)fromValue, (JSONConfig)this.jsonConfig).toBean(toValueType);
    }

    @Override
    public <T> T convertValue(Object fromValue, Type toValueType) {
        return (T)JSONUtil.parse((Object)fromValue, (JSONConfig)this.jsonConfig).toBean(toValueType);
    }
}

