/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.function.Predicate;

public class NetUtil {
    public static String getNetworkInterfaceIpV4(String interfaceName) {
        LinkedHashSet<InetAddress> addressList = NetUtil.getAddressList(networkInterface -> networkInterface.getName().equalsIgnoreCase(interfaceName), inetAddress -> inetAddress instanceof Inet4Address);
        return addressList.isEmpty() ? null : ((InetAddress)addressList.iterator().next()).getHostAddress();
    }

    public static LinkedHashSet<InetAddress> getAddressList(Predicate<NetworkInterface> networkInterfaceFilter, Predicate<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            if (networkInterfaceFilter != null && !networkInterfaceFilter.test(networkInterface)) continue;
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.test(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }
}

