/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.mica;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.tio.utils.mica.ExceptionUtils;
import org.tio.utils.mica.HexUtils;

public class DigestUtils {
    public static byte[] md5(byte[] bytes) {
        return DigestUtils.digest("MD5", bytes);
    }

    public static byte[] md5(String data) {
        return DigestUtils.md5(data.getBytes(StandardCharsets.UTF_8));
    }

    public static String md5Hex(String data) {
        return DigestUtils.encodeHex(DigestUtils.md5(data));
    }

    public static String md5Hex(byte[] bytes) {
        return DigestUtils.encodeHex(DigestUtils.md5(bytes));
    }

    public static byte[] sha1(String data) {
        return DigestUtils.sha1(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha1(byte[] bytes) {
        return DigestUtils.digest("SHA-1", bytes);
    }

    public static String sha1Hex(String data) {
        return DigestUtils.encodeHex(DigestUtils.sha1(data.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha1Hex(byte[] bytes) {
        return DigestUtils.encodeHex(DigestUtils.sha1(bytes));
    }

    public static byte[] sha224(String data) {
        return DigestUtils.sha224(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha224(byte[] bytes) {
        return DigestUtils.digest("SHA-224", bytes);
    }

    public static String sha224Hex(String data) {
        return DigestUtils.encodeHex(DigestUtils.sha224(data.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha224Hex(byte[] bytes) {
        return DigestUtils.encodeHex(DigestUtils.sha224(bytes));
    }

    public static byte[] sha256(String data) {
        return DigestUtils.sha256(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha256(byte[] bytes) {
        return DigestUtils.digest("SHA-256", bytes);
    }

    public static String sha256Hex(String data) {
        return DigestUtils.encodeHex(DigestUtils.sha256(data.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha256Hex(byte[] bytes) {
        return DigestUtils.encodeHex(DigestUtils.sha256(bytes));
    }

    public static byte[] sha384(String data) {
        return DigestUtils.sha384(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha384(byte[] bytes) {
        return DigestUtils.digest("SHA-384", bytes);
    }

    public static String sha384Hex(String data) {
        return DigestUtils.encodeHex(DigestUtils.sha384(data.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha384Hex(byte[] bytes) {
        return DigestUtils.encodeHex(DigestUtils.sha384(bytes));
    }

    public static byte[] sha512(String data) {
        return DigestUtils.sha512(data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] sha512(byte[] bytes) {
        return DigestUtils.digest("SHA-512", bytes);
    }

    public static String sha512Hex(String data) {
        return DigestUtils.encodeHex(DigestUtils.sha512(data.getBytes(StandardCharsets.UTF_8)));
    }

    public static String sha512Hex(byte[] bytes) {
        return DigestUtils.encodeHex(DigestUtils.sha512(bytes));
    }

    public static byte[] digest(String algorithm, byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            return md.digest(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static String digestHex(String algorithm, byte[] bytes) {
        return DigestUtils.encodeHex(DigestUtils.digest(algorithm, bytes));
    }

    public static byte[] hmacMd5(String data, String key) {
        return DigestUtils.hmacMd5(data.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] hmacMd5(byte[] bytes, String key) {
        return DigestUtils.digestHmac("HmacMD5", bytes, key);
    }

    public static String hmacMd5Hex(String data, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacMd5(data.getBytes(StandardCharsets.UTF_8), key));
    }

    public static String hmacMd5Hex(byte[] bytes, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacMd5(bytes, key));
    }

    public static byte[] hmacSha1(String data, String key) {
        return DigestUtils.hmacSha1(data.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] hmacSha1(byte[] bytes, String key) {
        return DigestUtils.digestHmac("HmacSHA1", bytes, key);
    }

    public static String hmacSha1Hex(String data, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha1(data.getBytes(StandardCharsets.UTF_8), key));
    }

    public static String hmacSha1Hex(byte[] bytes, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha1(bytes, key));
    }

    public static byte[] hmacSha224(String data, String key) {
        return DigestUtils.hmacSha224(data.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] hmacSha224(byte[] bytes, String key) {
        return DigestUtils.digestHmac("HmacSHA224", bytes, key);
    }

    public static String hmacSha224Hex(String data, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha224(data.getBytes(StandardCharsets.UTF_8), key));
    }

    public static String hmacSha224Hex(byte[] bytes, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha224(bytes, key));
    }

    public static byte[] hmacSha256(String data, String key) {
        return DigestUtils.hmacSha256(data.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] hmacSha256(byte[] bytes, String key) {
        return DigestUtils.digestHmac("HmacSHA256", bytes, key);
    }

    public static String hmacSha256Hex(String data, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha256(data.getBytes(StandardCharsets.UTF_8), key));
    }

    public static String hmacSha256Hex(byte[] bytes, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha256(bytes, key));
    }

    public static byte[] hmacSha384(String data, String key) {
        return DigestUtils.hmacSha384(data.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] hmacSha384(byte[] bytes, String key) {
        return DigestUtils.digestHmac("HmacSHA384", bytes, key);
    }

    public static String hmacSha384Hex(String data, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha384(data.getBytes(StandardCharsets.UTF_8), key));
    }

    public static String hmacSha384Hex(byte[] bytes, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha384(bytes, key));
    }

    public static byte[] hmacSha512(String data, String key) {
        return DigestUtils.hmacSha512(data.getBytes(StandardCharsets.UTF_8), key);
    }

    public static byte[] hmacSha512(byte[] bytes, String key) {
        return DigestUtils.digestHmac("HmacSHA512", bytes, key);
    }

    public static String hmacSha512Hex(String data, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha512(data.getBytes(StandardCharsets.UTF_8), key));
    }

    public static String hmacSha512Hex(byte[] bytes, String key) {
        return DigestUtils.encodeHex(DigestUtils.hmacSha512(bytes, key));
    }

    public static String digestHmacHex(String algorithm, String text, String key) {
        return DigestUtils.digestHmacHex(algorithm, text.getBytes(StandardCharsets.UTF_8), key);
    }

    public static String digestHmacHex(String algorithm, byte[] bytes, String key) {
        return DigestUtils.encodeHex(DigestUtils.digestHmac(algorithm, bytes, key));
    }

    public static byte[] digestHmac(String algorithm, byte[] bytes, String key) {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), algorithm);
        try {
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            return mac.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static String encodeHex(byte[] bytes) {
        return HexUtils.encodeToString(bytes);
    }

    public static byte[] decodeHex(String hexStr) {
        return HexUtils.decode(hexStr);
    }

    public static boolean slowEquals(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        return DigestUtils.slowEquals(a.getBytes(StandardCharsets.UTF_8), b.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean slowEquals(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }
}

