/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.mcp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.tio.utils.hutool.StrUtil;

public class UriTemplate {
    private static final int MAX_TEMPLATE_LENGTH = 1000000;
    private static final int MAX_VARIABLE_LENGTH = 1000000;
    private static final int MAX_TEMPLATE_EXPRESSIONS = 10000;
    private static final int MAX_REGEX_LENGTH = 1000000;
    private final String template;
    private final Pattern pattern;

    public String getTemplate() {
        return this.template;
    }

    public UriTemplate(String template) {
        if (StrUtil.isBlank((CharSequence)template)) {
            throw new IllegalArgumentException("Template cannot be null or empty");
        }
        UriTemplate.validateLength(template, 1000000, "Template");
        this.template = template;
        List<Part> parts = this.parseTemplate(template);
        this.pattern = Pattern.compile(this.createMatchingPattern(parts));
    }

    public String toString() {
        return this.template;
    }

    public boolean matchesTemplate(String uri) {
        UriTemplate.validateLength(uri, 1000000, "URI");
        return this.pattern.matcher(uri).matches();
    }

    private static void validateLength(String str, int max, String context) {
        if (str.length() > max) {
            throw new IllegalArgumentException(context + " exceeds maximum length of " + max + " characters (got " + str.length() + ")");
        }
    }

    private List<Part> parseTemplate(String template) {
        ArrayList<Part> parts = new ArrayList<Part>();
        StringBuilder literal = new StringBuilder();
        int expressionCount = 0;
        int index = 0;
        while (index < template.length()) {
            char ch = template.charAt(index);
            if (ch == '{') {
                int end;
                if (literal.length() > 0) {
                    parts.add(new LiteralPart(literal.toString()));
                    literal.setLength(0);
                }
                if ((end = template.indexOf(125, index)) == -1) {
                    throw new IllegalArgumentException("Unclosed template expression");
                }
                if (++expressionCount > 10000) {
                    throw new IllegalArgumentException("Too many template expressions");
                }
                String expr = template.substring(index + 1, end);
                parts.add(this.parseExpression(expr));
                index = end + 1;
                continue;
            }
            literal.append(ch);
            ++index;
        }
        if (literal.length() > 0) {
            parts.add(new LiteralPart(literal.toString()));
        }
        return parts;
    }

    private ExpressionPart parseExpression(String expr) {
        if (expr.trim().isEmpty()) {
            throw new IllegalArgumentException("Empty template expression");
        }
        String operator = this.extractOperator(expr);
        boolean exploded = expr.contains("*");
        List<String> names = this.extractNames(expr);
        if (names.isEmpty()) {
            throw new IllegalArgumentException("No variable names in template expression: " + expr);
        }
        names.forEach(name -> UriTemplate.validateLength(name, 1000000, "Variable name"));
        return new ExpressionPart(operator, names, exploded);
    }

    private String extractOperator(String expr) {
        switch (expr.charAt(0)) {
            case '#': 
            case '&': 
            case '+': 
            case '.': 
            case '/': 
            case '?': {
                return String.valueOf(expr.charAt(0));
            }
        }
        return "";
    }

    private List<String> extractNames(String expr) {
        String cleaned = expr.replaceAll("^[+.#/?&]", "");
        String[] nameParts = cleaned.split(",");
        ArrayList<String> names = new ArrayList<String>();
        for (String part : nameParts) {
            String trimmed = part.replace("*", "").trim();
            if (trimmed.isEmpty()) continue;
            names.add(trimmed);
        }
        return names;
    }

    private String createMatchingPattern(List<Part> parts) {
        StringBuilder patternBuilder = new StringBuilder("^");
        for (Part part : parts) {
            if (part instanceof ExpressionPart) {
                ExpressionPart exprPart = (ExpressionPart)part;
                patternBuilder.append(this.createPatternForExpressionPart(exprPart));
                continue;
            }
            if (!(part instanceof LiteralPart)) continue;
            LiteralPart literalPart = (LiteralPart)part;
            patternBuilder.append(Pattern.quote(literalPart.getLiteral()));
        }
        patternBuilder.append("$");
        String patternStr = patternBuilder.toString();
        UriTemplate.validateLength(patternStr, 1000000, "Generated regex pattern");
        return patternStr;
    }

    private String createPatternForExpressionPart(ExpressionPart part) {
        switch (part.getOperator()) {
            case "": 
            case "+": {
                return part.isExploded() ? "([^/]+(?:,[^/]+)*)" : "([^/,]+)";
            }
            case "#": {
                return "(.+)";
            }
            case ".": {
                return "\\.([^/,]+)";
            }
            case "/": {
                return "/" + (part.isExploded() ? "([^/]+(?:,[^/]+)*)" : "([^/,]+)");
            }
            case "?": 
            case "&": {
                return "\\?" + part.getVariableNames().get(0) + "=([^&]+)";
            }
        }
        return "([^/]+)";
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UriTemplate) {
            UriTemplate other = (UriTemplate)obj;
            return this.template.equals(other.template);
        }
        return false;
    }

    private static class ExpressionPart
    implements Part {
        private final String operator;
        private final List<String> variableNames;
        private final boolean exploded;

        public ExpressionPart(String operator, List<String> variableNames, boolean exploded) {
            this.operator = operator;
            this.variableNames = variableNames;
            this.exploded = exploded;
        }

        public String getOperator() {
            return this.operator;
        }

        public List<String> getVariableNames() {
            return this.variableNames;
        }

        public boolean isExploded() {
            return this.exploded;
        }
    }

    private static class LiteralPart
    implements Part {
        private final String literal;

        public LiteralPart(String literal) {
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }
    }

    private static interface Part {
    }
}

