/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Node;
import org.tio.core.exception.TioDecodeException;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpMultiBodyDecoder;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.Method;
import org.tio.http.common.RequestLine;
import org.tio.http.common.utils.HttpParseUtils;
import org.tio.http.common.utils.IpUtils;
import org.tio.utils.SysConst;
import org.tio.utils.hutool.StrUtil;

public class HttpRequestDecoder {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestDecoder.class);

    public static HttpRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext, HttpConfig httpConfig) throws TioDecodeException {
        Node realNode;
        int contentLength;
        HashMap<String, String> headers = new HashMap<String, String>();
        RequestLine firstLine = HttpRequestDecoder.parseRequestLine(buffer, httpConfig);
        if (firstLine == null) {
            return null;
        }
        boolean headerCompleted = HttpRequestDecoder.parseHeaderLine(buffer, headers, 0, httpConfig);
        if (!headerCompleted) {
            return null;
        }
        String contentLengthStr = (String)headers.get("content-length");
        if (StrUtil.isBlank((CharSequence)contentLengthStr)) {
            contentLength = 0;
        } else {
            contentLength = Integer.parseInt(contentLengthStr);
            if (contentLength > httpConfig.getMaxLengthOfPostBody()) {
                throw new TioDecodeException("post body length is too big[" + contentLength + "], max length is " + httpConfig.getMaxLengthOfPostBody() + " byte");
            }
        }
        int headerLength = buffer.position() - position;
        int allNeedLength = headerLength + contentLength;
        int notReceivedLength = allNeedLength - readableLength;
        if (notReceivedLength > 0) {
            if (notReceivedLength > channelContext.getReadBufferSize()) {
                channelContext.setReadBufferSize(notReceivedLength);
            }
            channelContext.setPacketNeededLength(Integer.valueOf(allNeedLength));
            return null;
        }
        String realIp = IpUtils.getRealIp(channelContext, httpConfig, headers);
        if (httpConfig.checkHost && !headers.containsKey("host")) {
            throw new TioDecodeException("there is no host header");
        }
        if (Objects.equals(realIp, channelContext.getClientNode().getIp())) {
            realNode = channelContext.getClientNode();
        } else {
            realNode = new Node(realIp, channelContext.getClientNode().getPort());
            channelContext.setProxyClientNode(realNode);
        }
        HttpRequest httpRequest = new HttpRequest(realNode);
        httpRequest.setRequestLine(firstLine);
        httpRequest.setChannelContext(channelContext);
        httpRequest.setHttpConfig(httpConfig);
        httpRequest.setHeaders(headers);
        httpRequest.setContentLength(contentLength);
        String connection = (String)headers.get("connection");
        if (connection != null) {
            httpRequest.setConnection(connection.toLowerCase());
        }
        if (StrUtil.isNotBlank((CharSequence)firstLine.queryString)) {
            HttpRequestDecoder.decodeParams(httpRequest.getParams(), firstLine.queryString, httpRequest.getCharset());
        }
        if (contentLength > 0) {
            byte[] bodyBytes = new byte[contentLength];
            buffer.get(bodyBytes);
            httpRequest.setBody(bodyBytes);
            HttpRequestDecoder.parseBody(httpRequest, firstLine, bodyBytes, channelContext, httpConfig);
        }
        return httpRequest;
    }

    public static void decodeParams(Map<String, Object[]> params, String queryString, Charset charset) throws TioDecodeException {
        String[] keyValues;
        if (StrUtil.isBlank((CharSequence)queryString)) {
            return;
        }
        for (String keyValue : keyValues = queryString.split("&")) {
            String[] newExistValue;
            String value;
            String[] keyValueArr = keyValue.split("=");
            String value1 = null;
            if (keyValueArr.length == 2) {
                value1 = keyValueArr[1];
            } else if (keyValueArr.length > 2) {
                throw new TioDecodeException("\u542b\u6709\u591a\u4e2a=");
            }
            String key = keyValueArr[0];
            if (StrUtil.isBlank((CharSequence)value1)) {
                value = null;
            } else {
                try {
                    value = URLDecoder.decode(value1, charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    throw new TioDecodeException((Throwable)e);
                }
            }
            Object[] existValue = params.get(key);
            if (existValue == null) {
                newExistValue = new String[]{value};
            } else {
                newExistValue = new String[existValue.length + 1];
                System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
                newExistValue[newExistValue.length - 1] = value;
            }
            params.put(key, newExistValue);
        }
    }

    private static void parseBody(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, ChannelContext channelContext, HttpConfig httpConfig) throws TioDecodeException {
        httpRequest.setBody(bodyBytes);
        HttpRequestDecoder.parseBodyFormat(httpRequest, httpRequest.getHeaders());
        HttpConst.RequestBodyFormat bodyFormat = httpRequest.getBodyFormat();
        switch (bodyFormat) {
            case PROTOBUF: {
                break;
            }
            case MULTIPART: {
                if (log.isDebugEnabled() && bodyBytes != null && bodyBytes.length > 0) {
                    String bodyString = new String(bodyBytes, httpRequest.getCharset());
                    log.debug("{} multipart body value\r\n{}", (Object)channelContext, (Object)bodyString);
                }
                String contentType = httpRequest.getHeader("content-type");
                String initboundary = HttpParseUtils.getSubAttribute(contentType, "boundary");
                if (log.isDebugEnabled()) {
                    log.debug("{}, initboundary:{}", (Object)channelContext, (Object)initboundary);
                }
                HttpMultiBodyDecoder.decode(httpRequest, firstLine, bodyBytes, initboundary, channelContext, httpConfig);
                break;
            }
            default: {
                String bodyString = null;
                if (bodyBytes != null && bodyBytes.length > 0) {
                    bodyString = new String(bodyBytes, httpRequest.getCharset());
                    httpRequest.setBodyString(bodyString);
                    if (log.isInfoEnabled()) {
                        log.info("{} body value\r\n{}", (Object)channelContext, (Object)bodyString);
                    }
                }
                if (bodyFormat != HttpConst.RequestBodyFormat.URLENCODED) break;
                HttpRequestDecoder.parseUrlencoded(httpRequest, bodyString);
            }
        }
    }

    public static void parseBodyFormat(HttpRequest httpRequest, Map<String, String> headers) {
        String contentTypeStr = headers.get("content-type");
        String contentType = null;
        if (contentTypeStr != null) {
            contentType = contentTypeStr.toLowerCase();
        }
        if (contentType == null) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.URLENCODED);
        } else if (contentType.startsWith("text/plain")) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.TEXT);
        } else if (contentType.startsWith("multipart/form-data")) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.MULTIPART);
        } else if (contentType.startsWith("application/x-protobuf")) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.PROTOBUF);
        } else {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.URLENCODED);
        }
        if (StrUtil.isNotBlank((CharSequence)contentType)) {
            String charset = HttpParseUtils.getSubAttribute(contentType, "charset");
            if (StrUtil.isNotBlank((CharSequence)charset)) {
                httpRequest.setCharset(Charset.forName(charset));
            } else {
                httpRequest.setCharset(SysConst.DEFAULT_CHARSET);
            }
        }
    }

    public static boolean parseHeaderLine(ByteBuffer buffer, Map<String, String> headers, int hasReceivedHeaderLength, HttpConfig httpConfig) throws TioDecodeException {
        int maxLengthOfRequestLine;
        int lineLength;
        int initPosition;
        byte[] allBs = buffer.array();
        int lastPosition = initPosition = buffer.position();
        int remaining = buffer.remaining();
        if (remaining == 0) {
            return false;
        }
        if (remaining > 1) {
            byte b1 = buffer.get();
            byte b2 = buffer.get();
            if (13 == b1 && 10 == b2) {
                return true;
            }
            if (10 == b1) {
                return true;
            }
        } else if (10 == buffer.get()) {
            return true;
        }
        String name = null;
        String value = null;
        boolean hasValue = false;
        boolean needIteration = false;
        while (buffer.hasRemaining()) {
            int len;
            byte lastByte;
            byte b = buffer.get();
            if (name == null) {
                if (b == 58) {
                    int len2 = buffer.position() - lastPosition - 1;
                    name = new String(allBs, lastPosition, len2);
                    lastPosition = buffer.position();
                    continue;
                }
                if (b != 10) continue;
                lastByte = buffer.get(buffer.position() - 2);
                len = buffer.position() - lastPosition - 1;
                if (lastByte == 13) {
                    len = buffer.position() - lastPosition - 2;
                }
                name = new String(allBs, lastPosition, len);
                headers.put(name.toLowerCase(), "");
                needIteration = true;
                break;
            }
            if (value != null) continue;
            if (b == 10) {
                lastByte = buffer.get(buffer.position() - 2);
                len = buffer.position() - lastPosition - 1;
                if (lastByte == 13) {
                    len = buffer.position() - lastPosition - 2;
                }
                value = new String(allBs, lastPosition, len);
                headers.put(name.toLowerCase(), StrUtil.trimEnd((CharSequence)value));
                needIteration = true;
                break;
            }
            if (!hasValue && b == 32) {
                lastPosition = buffer.position();
                continue;
            }
            hasValue = true;
        }
        if ((lineLength = buffer.position() - initPosition) > (maxLengthOfRequestLine = httpConfig.getMaxLengthOfRequestLine())) {
            throw new TioDecodeException(name + " header line is too long, max length of header line is " + maxLengthOfRequestLine);
        }
        if (needIteration) {
            int headerLength = lineLength + hasReceivedHeaderLength;
            int maxLengthOfHeader = httpConfig.getMaxLengthOfHeader();
            if (headerLength > maxLengthOfHeader) {
                throw new TioDecodeException("header is too long, max length of header is " + maxLengthOfHeader);
            }
            return HttpRequestDecoder.parseHeaderLine(buffer, headers, headerLength, httpConfig);
        }
        return false;
    }

    public static RequestLine parseRequestLine(ByteBuffer buffer, HttpConfig httpConfig) throws TioDecodeException {
        byte[] allBs = buffer.array();
        int initPosition = buffer.position();
        String methodStr = null;
        String pathStr = null;
        String queryStr = null;
        String protocol = null;
        String version = null;
        int lastPosition = initPosition;
        while (buffer.hasRemaining()) {
            int len;
            byte b = buffer.get();
            if (methodStr == null) {
                if (b != 32) continue;
                len = buffer.position() - lastPosition - 1;
                methodStr = new String(allBs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (pathStr == null) {
                if (b != 32 && b != 63) continue;
                len = buffer.position() - lastPosition - 1;
                pathStr = new String(allBs, lastPosition, len);
                lastPosition = buffer.position();
                if (b != 32) continue;
                queryStr = "";
                continue;
            }
            if (queryStr == null) {
                if (b != 32) continue;
                len = buffer.position() - lastPosition - 1;
                queryStr = new String(allBs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (protocol == null) {
                if (b != 47) continue;
                len = buffer.position() - lastPosition - 1;
                protocol = new String(allBs, lastPosition, len);
                lastPosition = buffer.position();
                continue;
            }
            if (version != null || b != 10) continue;
            byte lastByte = buffer.get(buffer.position() - 2);
            int len2 = buffer.position() - lastPosition - 1;
            if (lastByte == 13) {
                len2 = buffer.position() - lastPosition - 2;
            }
            version = new String(allBs, lastPosition, len2);
            RequestLine requestLine = new RequestLine();
            Method method = Method.from(methodStr);
            requestLine.setMethod(method);
            requestLine.setPath(pathStr);
            requestLine.setInitPath(pathStr);
            requestLine.setQueryString(queryStr);
            requestLine.setProtocol(protocol);
            requestLine.setVersion(version);
            return requestLine;
        }
        int maxLengthOfRequestLine = httpConfig.getMaxLengthOfRequestLine();
        if (buffer.position() - initPosition > maxLengthOfRequestLine) {
            throw new TioDecodeException("request line is too long, max length of RequestLine is " + maxLengthOfRequestLine);
        }
        return null;
    }

    private static void parseUrlencoded(HttpRequest httpRequest, String bodyString) throws TioDecodeException {
        HttpRequestDecoder.decodeParams(httpRequest.getParams(), bodyString, httpRequest.getCharset());
    }
}

