/*
 * Decompiled with CFR 0.152.
 */
package org.tio.http.common;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.exception.LengthOverflowException;
import org.tio.core.exception.TioDecodeException;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.RequestLine;
import org.tio.http.common.UploadFile;
import org.tio.http.common.utils.HttpParseUtils;
import org.tio.utils.buffer.ByteBufferUtil;
import org.tio.utils.hutool.StrUtil;

public class HttpMultiBodyDecoder {
    private static final Logger log = LoggerFactory.getLogger(HttpMultiBodyDecoder.class);

    public static void decode(HttpRequest request, RequestLine firstLine, byte[] bodyBytes, String initboundary, ChannelContext channelContext, HttpConfig httpConfig) throws TioDecodeException {
        if (StrUtil.isBlank((CharSequence)initboundary)) {
            throw new TioDecodeException("boundary is null");
        }
        long start = System.currentTimeMillis();
        ByteBuffer buffer = ByteBuffer.wrap(bodyBytes);
        buffer.position(0);
        String boundary = "--" + initboundary;
        String endBoundary = boundary + "--";
        Step step = Step.BOUNDARY;
        try {
            Header multiBodyHeader;
            do {
                String line;
                if (step == Step.BOUNDARY) {
                    String line2 = ByteBufferUtil.readLine((ByteBuffer)buffer, (Charset)request.getCharset(), (int)512);
                    if (boundary.equals(line2)) {
                        step = Step.HEADER;
                    } else {
                        if (endBoundary.equals(line2)) {
                            break;
                        }
                        throw new TioDecodeException("line need:" + boundary + ", but is: " + line2 + "");
                    }
                }
                multiBodyHeader = new Header();
                if (step != Step.HEADER) continue;
                ArrayList<String> lines = new ArrayList<String>(2);
                while (!"".equals(line = ByteBufferUtil.readLine((ByteBuffer)buffer, (Charset)request.getCharset(), (int)512))) {
                    lines.add(line);
                }
                HttpMultiBodyDecoder.parseHeader(lines, multiBodyHeader, channelContext);
                step = Step.BODY;
            } while (step != Step.BODY || (step = HttpMultiBodyDecoder.parseBody(multiBodyHeader, request, buffer, boundary, endBoundary, httpConfig)) != Step.END);
        }
        catch (LengthOverflowException loe) {
            throw new TioDecodeException((Throwable)loe);
        }
        finally {
            long end = System.currentTimeMillis();
            long iv = end - start;
            log.info("\u89e3\u6790\u8017\u65f6:{}ms", (Object)iv);
        }
    }

    public static Step parseBody(Header header, HttpRequest request, ByteBuffer buffer, String boundary, String endBoundary, HttpConfig httpConfig) throws LengthOverflowException, TioDecodeException {
        int initPosition = buffer.position();
        while (buffer.hasRemaining()) {
            String line = ByteBufferUtil.readLine((ByteBuffer)buffer, (Charset)request.getCharset(), (int)httpConfig.getMaxLengthOfMultiBody());
            boolean isEndBoundary = endBoundary.equals(line);
            boolean isBoundary = boundary.equals(line);
            if (!isBoundary && !isEndBoundary) continue;
            int endIndex = buffer.position() - line.getBytes().length - 2 - 2;
            int length = endIndex - initPosition;
            byte[] dst = new byte[length];
            System.arraycopy(buffer.array(), initPosition, dst, 0, length);
            String filename = header.getFilename();
            if (filename != null) {
                if (StrUtil.isNotBlank((CharSequence)filename)) {
                    UploadFile uploadFile = new UploadFile();
                    uploadFile.setName(filename.replace("%", ""));
                    uploadFile.setData(dst);
                    uploadFile.setSize(dst.length);
                    request.addParam(header.getName(), uploadFile);
                }
            } else {
                request.addParam(header.getName(), new String(dst, request.getCharset()));
            }
            if (isEndBoundary) {
                return Step.END;
            }
            return Step.HEADER;
        }
        log.error("\u6587\u4ef6\u4e0a\u4f20\uff0c\u534f\u8bae\u4e0d\u5bf9\uff0cstep is null");
        throw new TioDecodeException("step is null");
    }

    public static void parseHeader(List<String> lines, Header header, ChannelContext channelContext) throws TioDecodeException {
        if (lines == null || lines.isEmpty()) {
            throw new TioDecodeException("multipart_form_data \u683c\u5f0f\u4e0d\u5bf9\uff0c\u6ca1\u6709\u5934\u90e8\u4fe1\u606f");
        }
        try {
            for (String line : lines) {
                String[] keyvalue = line.split(":");
                String key = StrUtil.trim((String)keyvalue[0]).toLowerCase();
                String value = StrUtil.trim((String)keyvalue[1]);
                header.map.put(key, value);
            }
            String contentDisposition = (String)header.map.get(MultiBodyHeaderKey.Content_Disposition);
            String name = HttpParseUtils.getSubAttribute(contentDisposition, "name");
            String filename = HttpParseUtils.getSubAttribute(contentDisposition, "filename");
            String contentType = (String)header.map.get(MultiBodyHeaderKey.Content_Type);
            header.setContentDisposition(contentDisposition);
            header.setName(name);
            header.setFilename(filename);
            header.setContentType(contentType);
        }
        catch (Throwable e) {
            log.error(channelContext.toString(), e);
            throw new TioDecodeException(e.toString());
        }
    }

    public static class Header {
        private String contentDisposition = "form-data";
        private String name = null;
        private String filename = null;
        private String contentType = null;
        private Map<String, String> map = new HashMap<String, String>();

        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public Map<String, String> getMap() {
            return this.map;
        }

        public void setMap(Map<String, String> map) {
            this.map = map;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static interface MultiBodyHeaderKey {
        public static final String Content_Disposition = "Content-Disposition".toLowerCase();
        public static final String Content_Type = "Content-Type".toLowerCase();
    }

    public static enum Step {
        BOUNDARY,
        HEADER,
        BODY,
        END;

    }
}

