/*
 * Decompiled with CFR 0.152.
 */
package org.tio.core.ssl;

import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.core.intf.TioListener;
import org.tio.core.ssl.facade.IHandshakeCompletedListener;
import org.tio.core.task.SendRunnable;
import org.tio.server.TioServerConfig;
import org.tio.server.proxy.ProxyProtocolDecoder;

public class SslHandshakeCompletedListener
implements IHandshakeCompletedListener {
    private static final Logger log = LoggerFactory.getLogger(SslHandshakeCompletedListener.class);
    private final ChannelContext channelContext;

    public SslHandshakeCompletedListener(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void onComplete() {
        Packet packet;
        SendRunnable sendRunnable;
        Queue<Packet> forSendAfterSslHandshakeCompleted;
        TioListener tioListener;
        log.info("{}, \u5b8c\u6210SSL\u63e1\u624b", (Object)this.channelContext);
        this.channelContext.sslFacadeContext.setHandshakeCompleted(true);
        TioConfig tioConfig = this.channelContext.tioConfig;
        if (tioConfig.isServer() && ((TioServerConfig)tioConfig).isProxyProtocolEnabled()) {
            ProxyProtocolDecoder.enableProxyProtocol(this.channelContext);
        }
        if ((tioListener = tioConfig.getTioListener()) != null) {
            try {
                tioListener.onAfterConnected(this.channelContext, true, this.channelContext.isReconnect());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((forSendAfterSslHandshakeCompleted = (sendRunnable = this.channelContext.sendRunnable).getForSendAfterSslHandshakeCompleted(false)) == null || forSendAfterSslHandshakeCompleted.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("{} \u4e1a\u52a1\u5c42\u5728SSL\u63e1\u624b\u524d\u5c31\u6709{}\u6761\u6570\u636e\u5f85\u53d1\u9001", (Object)this.channelContext, (Object)forSendAfterSslHandshakeCompleted.size());
        }
        boolean isUseQueueSend = tioConfig.useQueueSend;
        while ((packet = forSendAfterSslHandshakeCompleted.poll()) != null) {
            if (isUseQueueSend) {
                sendRunnable.addMsg(packet);
                continue;
            }
            sendRunnable.sendPacket(packet);
        }
        if (isUseQueueSend) {
            sendRunnable.execute();
        }
    }
}

