/*
	Apache License
	Version 2.0, January 2004
	http://www.apache.org/licenses/

	TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

	1. Definitions.

	"License" shall mean the terms and conditions for use, reproduction, and
	distribution as defined by Sections 1 through 9 of this document.

	"Licensor" shall mean the copyright owner or entity authorized by the copyright
	owner that is granting the License.

	"Legal Entity" shall mean the union of the acting entity and all other entities
	that control, are controlled by, or are under common control with that entity.
	For the purposes of this definition, "control" means (i) the power, direct or
	indirect, to cause the direction or management of such entity, whether by
	contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the
	outstanding shares, or (iii) beneficial ownership of such entity.

	"You" (or "Your") shall mean an individual or Legal Entity exercising
	permissions granted by this License.

	"Source" form shall mean the preferred form for making modifications, including
	but not limited to software source code, documentation source, and configuration
	files.

	"Object" form shall mean any form resulting from mechanical transformation or
	translation of a Source form, including but not limited to compiled object code,
	generated documentation, and conversions to other media types.

	"Work" shall mean the work of authorship, whether in Source or Object form, made
	available under the License, as indicated by a copyright notice that is included
	in or attached to the work (an example is provided in the Appendix below).

	"Derivative Works" shall mean any work, whether in Source or Object form, that
	is based on (or derived from) the Work and for which the editorial revisions,
	annotations, elaborations, or other modifications represent, as a whole, an
	original work of authorship. For the purposes of this License, Derivative Works
	shall not include works that remain separable from, or merely link (or bind by
	name) to the interfaces of, the Work and Derivative Works thereof.

	"Contribution" shall mean any work of authorship, including the original version
	of the Work and any modifications or additions to that Work or Derivative Works
	thereof, that is intentionally submitted to Licensor for inclusion in the Work
	by the copyright owner or by an individual or Legal Entity authorized to submit
	on behalf of the copyright owner. For the purposes of this definition,
	"submitted" means any form of electronic, verbal, or written communication sent
	to the Licensor or its representatives, including but not limited to
	communication on electronic mailing lists, source code control systems, and
	issue tracking systems that are managed by, or on behalf of, the Licensor for
	the purpose of discussing and improving the Work, but excluding communication
	that is conspicuously marked or otherwise designated in writing by the copyright
	owner as "Not a Contribution."

	"Contributor" shall mean Licensor and any individual or Legal Entity on behalf
	of whom a Contribution has been received by Licensor and subsequently
	incorporated within the Work.

	2. Grant of Copyright License.

	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable copyright license to reproduce, prepare Derivative Works of,
	publicly display, publicly perform, sublicense, and distribute the Work and such
	Derivative Works in Source or Object form.

	3. Grant of Patent License.

	Subject to the terms and conditions of this License, each Contributor hereby
	grants to You a perpetual, worldwide, non-exclusive, no-charge, royalty-free,
	irrevocable (except as stated in this section) patent license to make, have
	made, use, offer to sell, sell, import, and otherwise transfer the Work, where
	such license applies only to those patent claims licensable by such Contributor
	that are necessarily infringed by their Contribution(s) alone or by combination
	of their Contribution(s) with the Work to which such Contribution(s) was
	submitted. If You institute patent litigation against any entity (including a
	cross-claim or counterclaim in a lawsuit) alleging that the Work or a
	Contribution incorporated within the Work constitutes direct or contributory
	patent infringement, then any patent licenses granted to You under this License
	for that Work shall terminate as of the date such litigation is filed.

	4. Redistribution.

	You may reproduce and distribute copies of the Work or Derivative Works thereof
	in any medium, with or without modifications, and in Source or Object form,
	provided that You meet the following conditions:

	You must give any other recipients of the Work or Derivative Works a copy of
	this License; and
	You must cause any modified files to carry prominent notices stating that You
	changed the files; and
	You must retain, in the Source form of any Derivative Works that You distribute,
	all copyright, patent, trademark, and attribution notices from the Source form
	of the Work, excluding those notices that do not pertain to any part of the
	Derivative Works; and
	If the Work includes a "NOTICE" text file as part of its distribution, then any
	Derivative Works that You distribute must include a readable copy of the
	attribution notices contained within such NOTICE file, excluding those notices
	that do not pertain to any part of the Derivative Works, in at least one of the
	following places: within a NOTICE text file distributed as part of the
	Derivative Works; within the Source form or documentation, if provided along
	with the Derivative Works; or, within a display generated by the Derivative
	Works, if and wherever such third-party notices normally appear. The contents of
	the NOTICE file are for informational purposes only and do not modify the
	License. You may add Your own attribution notices within Derivative Works that
	You distribute, alongside or as an addendum to the NOTICE text from the Work,
	provided that such additional attribution notices cannot be construed as
	modifying the License.
	You may add Your own copyright statement to Your modifications and may provide
	additional or different license terms and conditions for use, reproduction, or
	distribution of Your modifications, or for any such Derivative Works as a whole,
	provided Your use, reproduction, and distribution of the Work otherwise complies
	with the conditions stated in this License.

	5. Submission of Contributions.

	Unless You explicitly state otherwise, any Contribution intentionally submitted
	for inclusion in the Work by You to the Licensor shall be under the terms and
	conditions of this License, without any additional terms or conditions.
	Notwithstanding the above, nothing herein shall supersede or modify the terms of
	any separate license agreement you may have executed with Licensor regarding
	such Contributions.

	6. Trademarks.

	This License does not grant permission to use the trade names, trademarks,
	service marks, or product names of the Licensor, except as required for
	reasonable and customary use in describing the origin of the Work and
	reproducing the content of the NOTICE file.

	7. Disclaimer of Warranty.

	Unless required by applicable law or agreed to in writing, Licensor provides the
	Work (and each Contributor provides its Contributions) on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied,
	including, without limitation, any warranties or conditions of TITLE,
	NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are
	solely responsible for determining the appropriateness of using or
	redistributing the Work and assume any risks associated with Your exercise of
	permissions under this License.

	8. Limitation of Liability.

	In no event and under no legal theory, whether in tort (including negligence),
	contract, or otherwise, unless required by applicable law (such as deliberate
	and grossly negligent acts) or agreed to in writing, shall any Contributor be
	liable to You for damages, including any direct, indirect, special, incidental,
	or consequential damages of any character arising as a result of this License or
	out of the use or inability to use the Work (including but not limited to
	damages for loss of goodwill, work stoppage, computer failure or malfunction, or
	any and all other commercial damages or losses), even if such Contributor has
	been advised of the possibility of such damages.

	9. Accepting Warranty or Additional Liability.

	While redistributing the Work or Derivative Works thereof, You may choose to
	offer, and charge a fee for, acceptance of support, warranty, indemnity, or
	other liability obligations and/or rights consistent with this License. However,
	in accepting such obligations, You may act only on Your own behalf and on Your
	sole responsibility, not on behalf of any other Contributor, and only if You
	agree to indemnify, defend, and hold each Contributor harmless for any liability
	incurred by, or claims asserted against, such Contributor by reason of your
	accepting any such warranty or additional liability.

	END OF TERMS AND CONDITIONS

	APPENDIX: How to apply the Apache License to your work

	To apply the Apache License to your work, attach the following boilerplate
	notice, with the fields enclosed by brackets "{}" replaced with your own
	identifying information. (Don't include the brackets!) The text should be
	enclosed in the appropriate comment syntax for the file format. We also
	recommend that a file or class name and description of purpose be included on
	the same "printed page" as the copyright notice for easier identification within
	third-party archives.

	   Copyright 2018 JFinal

	   Licensed under the Apache License, Version 2.0 (the "License");
	   you may not use this file except in compliance with the License.
	   You may obtain a copy of the License at

	     http://www.apache.org/licenses/LICENSE-2.0

	   Unless required by applicable law or agreed to in writing, software
	   distributed under the License is distributed on an "AS IS" BASIS,
	   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	   See the License for the specific language governing permissions and
	   limitations under the License.
*/
package org.tio.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.client.TioClientConfig;
import org.tio.core.intf.*;
import org.tio.core.maintain.*;
import org.tio.core.ssl.SslConfig;
import org.tio.core.stat.GroupStat;
import org.tio.core.stat.vo.StatVo;
import org.tio.core.task.CloseRunnable;
import org.tio.core.task.HeartbeatMode;
import org.tio.core.uuid.DefaultTioUuid;
import org.tio.server.TioServerConfig;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;

import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author tanyaowu
 * 2016年10月10日 下午5:25:43
 */
public abstract class TioConfig {
	/**
	 * 默认的接收数据的buffer size
	 */
	public static final int READ_BUFFER_SIZE = Integer.getInteger("tio.default.read.buffer.size", 20480);
	/**
	 * 本jvm中所有的TioServerConfig对象
	 */
	public static final Set<TioServerConfig> ALL_SERVER_GROUP_CONTEXTS = new HashSet<>();
	/**
	 * 本jvm中所有的TioClientConfig对象
	 */
	public static final Set<TioClientConfig> ALL_CLIENT_GROUP_CONTEXTS = new HashSet<>();
	/**
	 * 本jvm中所有的TioConfig对象
	 */
	public static final Set<TioConfig> ALL_GROUP_CONTEXTS = new HashSet<>();
	/**
	 * 默认的超时时间，60 * 2 * 1000
	 */
	public static final long DEFAULT_HEARTBEAT_TIMEOUT = 120_000L;
	private static final AtomicInteger ID_ATOMIC = new AtomicInteger();
	static Logger log = LoggerFactory.getLogger(TioConfig.class);
	public final String id;
	public boolean isShortConnection = false;
	public SslConfig sslConfig = null;
	public boolean debug = false;
	public GroupStat groupStat = null;
	public boolean statOn = true;
	public PacketConverter packetConverter = null;
	/**
	 * 启动时间
	 */
	public long startTime = System.currentTimeMillis();
	/**
	 * 是否用队列发送
	 */
	public boolean useQueueSend = true;
	/**
	 * 是否用队列解码（系统初始化时确定该值，中途不要变更此值，否则在切换的时候可能导致消息丢失）
	 */
	public boolean useQueueDecode = false;
	/**
	 * 心跳超时时间(单位: 毫秒)，如果用户不希望框架层面做心跳相关工作，请把此值设为0或负数
	 */
	public long heartbeatTimeout = DEFAULT_HEARTBEAT_TIMEOUT;
	/**
	 * 心跳检测模式
	 */
	private HeartbeatMode heartbeatMode = HeartbeatMode.ANY;
	/**
	 * 解码出现异常时，是否打印异常日志
	 */
	public boolean logWhenDecodeError = false;
	public PacketHandlerMode packetHandlerMode = PacketHandlerMode.SINGLE_THREAD;    //.queue;
	public SynThreadPoolExecutor tioExecutor;
	public CloseRunnable closeRunnable;
	public ExecutorService groupExecutor;
	public ClientNodes clientNodes = new ClientNodes();
	public Set<ChannelContext> connections = ConcurrentHashMap.newKeySet();
	public Groups groups = new Groups();
	public Users users = new Users();
	public Tokens tokens = new Tokens();
	public Ids ids = new Ids();
	public BsIds bsIds = new BsIds();
	/**
	 * 解码失败多少次抛出异常
	 */
	public int maxDecodeFailCount = 10;
	public ConcurrentMap<Integer, Packet> waitingResps = new ConcurrentHashMap<>();
	protected String name = "未命名";
	private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
	/**
	 * 接收数据的buffer size
	 */
	private int readBufferSize = READ_BUFFER_SIZE;
	private GroupListener groupListener = null;
	private TioUuid tioUuid = new DefaultTioUuid();
	private boolean isStopped = false;

	public TioConfig() {
		this(null, null);
	}

	/**
	 * @param tioExecutor   tioExecutor
	 * @param groupExecutor groupExecutor
	 */
	public TioConfig(SynThreadPoolExecutor tioExecutor, ExecutorService groupExecutor) {
		super();
		ALL_GROUP_CONTEXTS.add(this);
		if (this instanceof TioServerConfig) {
			ALL_SERVER_GROUP_CONTEXTS.add((TioServerConfig) this);
		} else {
			ALL_CLIENT_GROUP_CONTEXTS.add((TioClientConfig) this);
		}
		if (ALL_GROUP_CONTEXTS.size() > 20) {
			log.warn("已经产生{}个TioConfig对象，t-io作者怀疑你在误用t-io", ALL_GROUP_CONTEXTS.size());
		}
		this.id = Integer.toString(ID_ATOMIC.incrementAndGet());
		this.tioExecutor = tioExecutor;
		if (this.tioExecutor == null) {
			this.tioExecutor = ThreadUtils.getTioExecutor();
		}
		this.groupExecutor = groupExecutor;
		if (this.groupExecutor == null) {
			this.groupExecutor = ThreadUtils.getGroupExecutor();
		}
		closeRunnable = new CloseRunnable(this.tioExecutor);
	}

	/**
	 * 获取TioHandler对象
	 *
	 * @return TioHandler
	 */
	public abstract TioHandler getTioHandler();

	/**
	 * 获取TioListener对象
	 *
	 * @return TioListener
	 */
	public abstract TioListener getTioListener();

	/**
	 * @return ByteOrder
	 */
	public ByteOrder getByteOrder() {
		return byteOrder;
	}

	/**
	 * @param byteOrder ByteOrder
	 */
	public void setByteOrder(ByteOrder byteOrder) {
		this.byteOrder = byteOrder;
	}

	/**
	 * @return the groupListener
	 */
	public GroupListener getGroupListener() {
		return groupListener;
	}

	/**
	 * @param groupListener the groupListener to set
	 */
	public void setGroupListener(GroupListener groupListener) {
		this.groupListener = groupListener;
	}

	/**
	 * @return id
	 */
	public String getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the tioUuid
	 */
	public TioUuid getTioUuid() {
		return tioUuid;
	}

	/**
	 * @param tioUuid the tioUuid to set
	 */
	public void setTioUuid(TioUuid tioUuid) {
		this.tioUuid = tioUuid;
	}

	/**
	 * @return the syns
	 */
	public Map<Integer, Packet> getWaitingResps() {
		return waitingResps;
	}

	/**
	 * @return the isStop
	 */
	public boolean isStopped() {
		return isStopped;
	}

	/**
	 * @param isStopped the isStop to set
	 */
	public void setStopped(boolean isStopped) {
		this.isStopped = isStopped;
	}

	/**
	 * @param heartbeatTimeout the heartbeatTimeout to set
	 */
	public void setHeartbeatTimeout(long heartbeatTimeout) {
		this.heartbeatTimeout = heartbeatTimeout;
	}

	public HeartbeatMode getHeartbeatMode() {
		return heartbeatMode;
	}

	public void setHeartbeatMode(HeartbeatMode heartbeatMode) {
		this.heartbeatMode = heartbeatMode;
	}

	/**
	 * @param packetHandlerMode the packetHandlerMode to set
	 */
	public void setPacketHandlerMode(PacketHandlerMode packetHandlerMode) {
		this.packetHandlerMode = packetHandlerMode;
	}

	/**
	 * @param isShortConnection the isShortConnection to set
	 */
	public void setShortConnection(boolean isShortConnection) {
		this.isShortConnection = isShortConnection;
	}

	public void setSslConfig(SslConfig sslConfig) {
		this.sslConfig = sslConfig;
	}

	public GroupStat getGroupStat() {
		return groupStat;
	}

	/**
	 * 是否用队列解码（系统初始化时确定该值，中途不要变更此值，否则在切换的时候可能导致消息丢失
	 *
	 * @param useQueueDecode useQueueDecode
	 */
	public void setUseQueueDecode(boolean useQueueDecode) {
		this.useQueueDecode = useQueueDecode;
	}

	/**
	 * 是否用队列发送，可以随时切换
	 *
	 * @param useQueueSend useQueueSend
	 */
	public void setUseQueueSend(boolean useQueueSend) {
		this.useQueueSend = useQueueSend;
	}

	/**
	 * 是服务器端还是客户端
	 *
	 * @return 是否服务端
	 */
	public abstract boolean isServer();

	/**
	 * 获取统计数据
	 *
	 * @return StatVo
	 */
	public abstract StatVo getStat();

	public int getReadBufferSize() {
		return readBufferSize;
	}

	/**
	 * @param readBufferSize the readBufferSize to set
	 */
	public void setReadBufferSize(int readBufferSize) {
		this.readBufferSize = Math.min(readBufferSize, TcpConst.MAX_DATA_LENGTH);
	}

	public boolean isSsl() {
		return sslConfig != null;
	}

	/**
	 * 停止时删除客户端
	 */
	public void remove() {
		ALL_GROUP_CONTEXTS.remove(this);
		if (isServer()) {
			ALL_SERVER_GROUP_CONTEXTS.remove(this);
		} else {
			ALL_CLIENT_GROUP_CONTEXTS.remove(this);
		}
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		TioConfig tioConfig = (TioConfig) o;
		return Objects.equals(id, tioConfig.id);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id);
	}

}
