/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import net.dreamlu.mica.core.utils.ConvertUtil;
import net.dreamlu.mica.core.utils.ReflectUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.http.JsonPointer;
import net.dreamlu.mica.http.JsonPointerUtil;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ReflectionUtils;

public class JsonPointerMethodInterceptor
implements MethodInterceptor {
    private final Class<?> clazz;
    private final JsonNode jsonNode;

    public @Nullable Object intercept(Object object, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (ReflectionUtils.isObjectMethod((Method)method)) {
            return methodProxy.invokeSuper(object, args);
        }
        PropertyDescriptor propertyDescriptor = BeanUtils.findPropertyForMethod((Method)method, this.clazz);
        if (propertyDescriptor == null) {
            return methodProxy.invokeSuper(object, args);
        }
        if (!method.equals(propertyDescriptor.getReadMethod())) {
            return methodProxy.invokeSuper(object, args);
        }
        String fieldName = StringUtil.firstCharToLower((String)propertyDescriptor.getDisplayName());
        Field field = ReflectUtil.findField(this.clazz, (String)fieldName);
        if (field == null) {
            return methodProxy.invokeSuper(object, args);
        }
        JsonPointer jsonPointer = (JsonPointer)AnnotationUtils.getAnnotation((AnnotatedElement)field, JsonPointer.class);
        if (jsonPointer == null) {
            return methodProxy.invokeSuper(object, args);
        }
        Class<?> returnType = method.getReturnType();
        boolean isColl = Collection.class.isAssignableFrom(returnType);
        String jsonPointerValue = jsonPointer.value();
        boolean isInner = jsonPointer.inner();
        if (isInner) {
            return this.proxyInner(jsonPointerValue, method, returnType, isColl);
        }
        Object proxyValue = this.proxyValue(jsonPointerValue, returnType, isColl);
        if (String.class.isAssignableFrom(returnType)) {
            return proxyValue;
        }
        TypeDescriptor typeDescriptor = new TypeDescriptor(field);
        return ConvertUtil.convert((Object)proxyValue, (TypeDescriptor)typeDescriptor);
    }

    private @Nullable Object proxyValue(String jsonPointerValue, Class<?> returnType, boolean isColl) {
        if (isColl) {
            JsonNode nodes = this.jsonNode.at(jsonPointerValue);
            Collection<Object> valueList = this.newColl(returnType);
            if (nodes.isEmpty()) {
                return valueList;
            }
            for (JsonNode node : nodes) {
                String value = this.getValue(node);
                if (value == null) continue;
                valueList.add(value);
            }
            return valueList;
        }
        return this.getValue(this.jsonNode.at(jsonPointerValue));
    }

    private Object proxyInner(String jsonPointerValue, Method method, Class<?> returnType, boolean isColl) {
        if (isColl) {
            JsonNode nodes = this.jsonNode.at(jsonPointerValue);
            Collection<Object> valueList = this.newColl(returnType);
            ResolvableType resolvableType = ResolvableType.forMethodReturnType((Method)method);
            Class innerType = resolvableType.getGeneric(new int[]{0}).resolve();
            if (innerType == null) {
                throw new IllegalArgumentException("Class " + returnType + " \u8bfb\u53d6\u6cdb\u578b\u5931\u8d25\u3002");
            }
            for (JsonNode node : nodes) {
                valueList.add(JsonPointerUtil.readValue(node, innerType));
            }
            return valueList;
        }
        return JsonPointerUtil.readValue(this.jsonNode.at(jsonPointerValue), returnType);
    }

    private @Nullable String getValue(@Nullable JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.asText();
    }

    private Collection<Object> newColl(Class<?> returnType) {
        return Set.class.isAssignableFrom(returnType) ? new HashSet() : new ArrayList();
    }

    @Generated
    public JsonPointerMethodInterceptor(Class<?> clazz, JsonNode jsonNode) {
        this.clazz = clazz;
        this.jsonNode = jsonNode;
    }
}

