/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class InMemoryCookieManager
implements CookieJar {
    private final Set<Cookie> cookieSet = new CopyOnWriteArraySet<Cookie>();

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
        this.cookieSet.addAll(cookies);
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList<Cookie> needRemoveCookieList = new ArrayList<Cookie>();
        ArrayList<Cookie> matchedCookieList = new ArrayList<Cookie>();
        for (Cookie cookie : this.cookieSet) {
            if (InMemoryCookieManager.isCookieExpired(cookie)) {
                needRemoveCookieList.add(cookie);
                continue;
            }
            if (!cookie.matches(url)) continue;
            matchedCookieList.add(cookie);
        }
        if (!needRemoveCookieList.isEmpty()) {
            needRemoveCookieList.forEach(this.cookieSet::remove);
        }
        return matchedCookieList;
    }

    private static boolean isCookieExpired(Cookie cookie) {
        return cookie.expiresAt() < System.currentTimeMillis();
    }
}

