/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.http.ResponseSpec;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jspecify.annotations.Nullable;

public class HttpResponse
implements ResponseSpec,
Closeable {
    private final Request request;
    private final Response response;
    private final ResponseBody body;

    HttpResponse(Response response) {
        this.request = response.request();
        this.response = response;
        this.body = HttpResponse.ifNullBodyToEmpty(response.body());
    }

    @Override
    public int code() {
        return this.response.code();
    }

    @Override
    public String message() {
        return this.response.message();
    }

    @Override
    public boolean isOk() {
        return this.response.isSuccessful();
    }

    @Override
    public boolean isRedirect() {
        return this.response.isRedirect();
    }

    @Override
    public Headers headers() {
        return this.response.headers();
    }

    @Override
    public List<Cookie> cookies() {
        return Cookie.parseAll((HttpUrl)this.request.url(), (Headers)this.headers());
    }

    @Override
    public Request rawRequest() {
        return this.request;
    }

    @Override
    public Response rawResponse() {
        return this.response;
    }

    @Override
    public ResponseBody rawBody() {
        return this.body;
    }

    @Override
    public String asString() {
        try {
            return this.body.string();
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public String asString(Charset charset) {
        return new String(this.asBytes(), charset);
    }

    @Override
    public byte[] asBytes() {
        try {
            return this.body.bytes();
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public InputStream asStream() {
        return this.body.byteStream();
    }

    @Override
    public JsonNode asJsonNode() {
        return JsonUtil.readTree((byte[])this.asBytes());
    }

    @Override
    public <T> T asValue(Class<T> valueType) {
        return (T)JsonUtil.readValue((byte[])this.asBytes(), valueType);
    }

    @Override
    public <T> T asValue(TypeReference<T> typeReference) {
        return (T)JsonUtil.readValue((byte[])this.asBytes(), typeReference);
    }

    @Override
    public <T> List<T> asList(Class<T> valueType) {
        return JsonUtil.readList((byte[])this.asBytes(), valueType);
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<?> keyClass, Class<?> valueType) {
        return JsonUtil.readMap((byte[])this.asBytes(), keyClass, valueType);
    }

    @Override
    public <V> Map<String, V> asMap(Class<?> valueType) {
        return this.asMap(String.class, valueType);
    }

    @Override
    public File toFile(File file) {
        this.toFile(file.toPath());
        return file;
    }

    @Override
    public Path toFile(Path path) {
        try {
            Files.copy(this.asStream(), path, new CopyOption[0]);
            return path;
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    @Override
    public MediaType contentType() {
        return this.body.contentType();
    }

    @Override
    public long contentLength() {
        return this.body.contentLength();
    }

    public String toString() {
        return this.response.toString();
    }

    static ResponseBody ifNullBodyToEmpty(@Nullable ResponseBody body) {
        return body == null ? Util.EMPTY_RESPONSE : body;
    }

    @Override
    public void close() throws IOException {
        Util.closeQuietly((Closeable)this.response);
    }
}

