/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.dreamlu.mica.core.retry.IRetry;
import net.dreamlu.mica.core.retry.SimpleRetry;
import net.dreamlu.mica.core.ssl.DisableValidationTrustManager;
import net.dreamlu.mica.core.ssl.TrustAllHostNames;
import net.dreamlu.mica.core.tuple.Pair;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.core.utils.ResourceUtil;
import net.dreamlu.mica.http.AsyncExchange;
import net.dreamlu.mica.http.BaseAuthenticator;
import net.dreamlu.mica.http.CompletableCallback;
import net.dreamlu.mica.http.Exchange;
import net.dreamlu.mica.http.FormBuilder;
import net.dreamlu.mica.http.HttpConsoleLogger;
import net.dreamlu.mica.http.HttpLogger;
import net.dreamlu.mica.http.HttpLoggingInterceptor;
import net.dreamlu.mica.http.LogLevel;
import net.dreamlu.mica.http.MultipartFormBuilder;
import net.dreamlu.mica.http.ResponseSpec;
import net.dreamlu.mica.http.RetryInterceptor;
import okhttp3.Authenticator;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.EventListener;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;
import org.jspecify.annotations.Nullable;

public class HttpRequest {
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0";
    private static final MediaType APPLICATION_JSON = MediaType.get((String)"application/json");
    private static volatile OkHttpClient httpClient = new OkHttpClient();
    private static @Nullable HttpLoggingInterceptor globalLoggingInterceptor = null;
    private final Request.Builder requestBuilder;
    private final HttpUrl.Builder uriBuilder;
    private final String httpMethod;
    private String userAgent;
    private @Nullable RequestBody requestBody;
    private @Nullable Boolean followRedirects;
    private @Nullable Boolean followSslRedirects;
    private @Nullable HttpLoggingInterceptor.Logger logger;
    private @Nullable LogLevel logLevel;
    private @Nullable CookieJar cookieJar;
    private @Nullable EventListener eventListener;
    private final List<Interceptor> interceptors = new ArrayList<Interceptor>();
    private @Nullable Authenticator authenticator;
    private @Nullable Duration connectTimeout;
    private @Nullable Duration readTimeout;
    private @Nullable Duration writeTimeout;
    private @Nullable List<Protocol> protocols;
    private @Nullable Proxy proxy;
    private @Nullable ProxySelector proxySelector;
    private @Nullable Authenticator proxyAuthenticator;
    private @Nullable IRetry retry;
    private @Nullable Predicate<ResponseSpec> respPredicate;
    private @Nullable HostnameVerifier hostnameVerifier;
    private @Nullable SSLSocketFactory sslSocketFactory;
    private @Nullable X509TrustManager trustManager;

    public static HttpRequest get(String url) {
        return new HttpRequest(new Request.Builder(), url, "GET");
    }

    public static HttpRequest get(URI uri) {
        return HttpRequest.get(uri.toString());
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(new Request.Builder(), url, "POST");
    }

    public static HttpRequest post(URI uri) {
        return HttpRequest.post(uri.toString());
    }

    public static HttpRequest patch(String url) {
        return new HttpRequest(new Request.Builder(), url, "PATCH");
    }

    public static HttpRequest patch(URI uri) {
        return HttpRequest.patch(uri.toString());
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(new Request.Builder(), url, "PUT");
    }

    public static HttpRequest put(URI uri) {
        return HttpRequest.put(uri.toString());
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(new Request.Builder(), url, "DELETE");
    }

    public static HttpRequest delete(URI uri) {
        return HttpRequest.delete(uri.toString());
    }

    public HttpRequest pathParam(String name, Object value) {
        Objects.requireNonNull(name, "name == null");
        List segments = this.uriBuilder.build().pathSegments();
        String pathParamName = "{" + name.trim() + "}";
        for (int i = 0; i < segments.size(); ++i) {
            if (!pathParamName.equalsIgnoreCase((String)segments.get(i))) continue;
            this.uriBuilder.setPathSegment(i, HttpRequest.handleValue(value));
        }
        return this;
    }

    public HttpRequest query(String query) {
        this.uriBuilder.query(query);
        return this;
    }

    public HttpRequest queryEncoded(String encodedQuery) {
        this.uriBuilder.encodedQuery(encodedQuery);
        return this;
    }

    public HttpRequest queryMap(@Nullable Map<String, Object> queryMap) {
        if (queryMap != null && !queryMap.isEmpty()) {
            queryMap.forEach(this::query);
        }
        return this;
    }

    public HttpRequest query(String name, @Nullable Object value) {
        if (value != null) {
            this.uriBuilder.addQueryParameter(name, String.valueOf(value));
        }
        return this;
    }

    public HttpRequest queryEncoded(String encodedName, @Nullable Object encodedValue) {
        if (encodedValue != null) {
            this.uriBuilder.addEncodedQueryParameter(encodedName, String.valueOf(encodedValue));
        }
        return this;
    }

    HttpRequest form(FormBody formBody) {
        this.requestBody = formBody;
        return this;
    }

    HttpRequest multipartForm(MultipartBody multipartBody) {
        this.requestBody = multipartBody;
        return this;
    }

    public FormBuilder formBuilder() {
        return new FormBuilder(this);
    }

    public MultipartFormBuilder multipartFormBuilder() {
        return new MultipartFormBuilder(this);
    }

    public HttpRequest body(RequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public HttpRequest body(byte[] body) {
        return this.body(RequestBody.create((byte[])body));
    }

    public HttpRequest body(byte[] body, MediaType contentType) {
        return this.body(RequestBody.create((byte[])body, (MediaType)contentType));
    }

    public HttpRequest body(File body, MediaType contentType) {
        return this.body(RequestBody.create((File)body, (MediaType)contentType));
    }

    public HttpRequest body(String body, MediaType contentType) {
        return this.body(RequestBody.create((String)body, (MediaType)contentType));
    }

    public HttpRequest bodyString(String body) {
        return this.body(RequestBody.create((String)body, (MediaType)APPLICATION_JSON));
    }

    public HttpRequest bodyString(MediaType contentType, String body) {
        return this.body(RequestBody.create((String)body, (MediaType)contentType));
    }

    public HttpRequest bodyJson(Object body) {
        return this.bodyString(JsonUtil.toJson((Object)body));
    }

    public HttpRequest bodyJson(Object body, MediaType contentType) {
        return this.body(JsonUtil.toJsonAsBytes((Object)body), contentType);
    }

    private HttpRequest(Request.Builder requestBuilder, String url, String httpMethod) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalArgumentException(String.format("Url \u4e0d\u80fd\u89e3\u6790: %s: [%s]\u3002", httpMethod.toLowerCase(), url));
        }
        this.requestBuilder = requestBuilder;
        this.uriBuilder = httpUrl.newBuilder();
        this.httpMethod = httpMethod;
        this.userAgent = DEFAULT_USER_AGENT;
    }

    private Call internalCall(OkHttpClient client) {
        OkHttpClient.Builder builder = client.newBuilder();
        if (this.connectTimeout != null) {
            builder.connectTimeout(this.connectTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.readTimeout != null) {
            builder.readTimeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.writeTimeout != null) {
            builder.writeTimeout(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.protocols != null && !this.protocols.isEmpty()) {
            builder.protocols(this.protocols);
        }
        if (this.proxy != null) {
            builder.proxy(this.proxy);
        }
        if (this.proxySelector != null) {
            builder.proxySelector(this.proxySelector);
        }
        if (this.proxyAuthenticator != null) {
            builder.proxyAuthenticator(this.proxyAuthenticator);
        }
        if (this.sslSocketFactory != null && this.trustManager != null) {
            builder.sslSocketFactory(this.sslSocketFactory, this.trustManager);
            if (this.hostnameVerifier == null) {
                this.hostnameVerifier = TrustAllHostNames.INSTANCE;
            }
        }
        if (this.hostnameVerifier != null) {
            builder.hostnameVerifier(this.hostnameVerifier);
        }
        if (this.authenticator != null) {
            builder.authenticator(this.authenticator);
        }
        if (this.eventListener != null) {
            builder.eventListener(this.eventListener);
        }
        if (!this.interceptors.isEmpty()) {
            builder.interceptors().addAll(this.interceptors);
        }
        if (this.cookieJar != null) {
            builder.cookieJar(this.cookieJar);
        }
        if (this.followRedirects != null) {
            builder.followRedirects(this.followRedirects.booleanValue());
        }
        if (this.followSslRedirects != null) {
            builder.followSslRedirects(this.followSslRedirects.booleanValue());
        }
        if (this.retry != null) {
            builder.addInterceptor((Interceptor)new RetryInterceptor(this.retry, this.respPredicate));
        }
        if (this.logger != null && this.logLevel != null && LogLevel.NONE != this.logLevel) {
            builder.addInterceptor((Interceptor)HttpRequest.getLoggingInterceptor(this.logger, this.logLevel));
        } else if (globalLoggingInterceptor != null) {
            builder.addInterceptor((Interceptor)globalLoggingInterceptor);
        }
        this.requestBuilder.header("User-Agent", this.userAgent);
        this.requestBuilder.url(this.uriBuilder.build());
        String method = this.httpMethod;
        Request request = HttpMethod.requiresRequestBody((String)method) && this.requestBody == null ? this.requestBuilder.method(method, Util.EMPTY_REQUEST).build() : this.requestBuilder.method(method, this.requestBody).build();
        return builder.build().newCall(request);
    }

    public Exchange execute() {
        return new Exchange(this.internalCall(httpClient));
    }

    public AsyncExchange async() {
        return new AsyncExchange(this.internalCall(httpClient));
    }

    public CompletableFuture<ResponseSpec> executeAsync() {
        CompletableFuture<ResponseSpec> future = new CompletableFuture<ResponseSpec>();
        Call call = this.internalCall(httpClient);
        call.enqueue((Callback)new CompletableCallback(future));
        return future;
    }

    public ResponseSpec executeAsyncAndJoin() {
        return this.executeAsync().join();
    }

    public HttpRequest baseAuth(String userName, String password) {
        return this.authenticator(new BaseAuthenticator(userName, password));
    }

    public HttpRequest addHeader(Map<String, String> headers) {
        this.requestBuilder.headers(Headers.of(headers));
        return this;
    }

    public HttpRequest addHeader(String ... namesAndValues) {
        Headers headers = Headers.of((String[])namesAndValues);
        this.requestBuilder.headers(headers);
        return this;
    }

    public HttpRequest addHeader(String name, String value) {
        this.requestBuilder.addHeader(name, value);
        return this;
    }

    public HttpRequest setHeader(String name, String value) {
        this.requestBuilder.header(name, value);
        return this;
    }

    public HttpRequest removeHeader(String name) {
        this.requestBuilder.removeHeader(name);
        return this;
    }

    public HttpRequest addCookie(Cookie cookie) {
        this.addHeader("Cookie", cookie.toString());
        return this;
    }

    public HttpRequest addCookie(Consumer<Cookie.Builder> consumer) {
        Cookie.Builder builder = new Cookie.Builder();
        consumer.accept(builder);
        this.addHeader("Cookie", builder.build().toString());
        return this;
    }

    public HttpRequest cacheControl(CacheControl cacheControl) {
        this.requestBuilder.cacheControl(cacheControl);
        return this;
    }

    public HttpRequest userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpRequest followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public HttpRequest followSslRedirects(boolean followSslRedirects) {
        this.followSslRedirects = followSslRedirects;
        return this;
    }

    private static HttpLoggingInterceptor getLoggingInterceptor(HttpLoggingInterceptor.Logger httpLogger, LogLevel level) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(httpLogger);
        loggingInterceptor.setLevel(level);
        return loggingInterceptor;
    }

    public HttpRequest useSlf4jLog() {
        return this.useSlf4jLog(LogLevel.BODY);
    }

    public HttpRequest useSlf4jLog(LogLevel logLevel) {
        return this.useLog(HttpLogger.Slf4j, logLevel);
    }

    public HttpRequest useConsoleLog() {
        return this.useConsoleLog(LogLevel.BODY);
    }

    public HttpRequest useConsoleLog(LogLevel logLevel) {
        return this.useLog(HttpConsoleLogger.INSTANCE, logLevel);
    }

    public HttpRequest useDefaultLog() {
        return this.useDefaultLog(LogLevel.BODY);
    }

    public HttpRequest useDefaultLog(LogLevel logLevel) {
        return this.useLog(HttpLoggingInterceptor.Logger.DEFAULT, logLevel);
    }

    public HttpRequest useLog(HttpLoggingInterceptor.Logger logger) {
        return this.useLog(logger, LogLevel.BODY);
    }

    public HttpRequest useLog(HttpLoggingInterceptor.Logger logger, LogLevel logLevel) {
        this.logger = logger;
        this.logLevel = logLevel;
        return this;
    }

    public HttpRequest authenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public HttpRequest eventListener(EventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }

    public HttpRequest interceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    public HttpRequest cookieManager(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
        return this;
    }

    public HttpRequest connectTimeout(Duration timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public HttpRequest readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public HttpRequest writeTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public HttpRequest protocols(List<Protocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    public HttpRequest proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpRequest proxy(Proxy.Type type, InetSocketAddress address) {
        return this.proxy(new Proxy(type, address));
    }

    public HttpRequest proxy(InetSocketAddress address) {
        return this.proxy(Proxy.Type.HTTP, address);
    }

    public HttpRequest proxy(String hostname, int port) {
        return this.proxy(InetSocketAddress.createUnresolved(hostname, port));
    }

    public HttpRequest proxySelector(ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    public HttpRequest proxyAuthenticator(Authenticator proxyAuthenticator) {
        this.proxyAuthenticator = proxyAuthenticator;
        return this;
    }

    public HttpRequest retry() {
        return this.retry((IRetry)new SimpleRetry());
    }

    public HttpRequest retryOn(Predicate<ResponseSpec> respPredicate) {
        return this.retry((IRetry)new SimpleRetry(), respPredicate);
    }

    public HttpRequest retry(int maxAttempts, long sleepMillis) {
        return this.retry((IRetry)new SimpleRetry(maxAttempts, sleepMillis));
    }

    public HttpRequest retry(int maxAttempts, long sleepMillis, Predicate<ResponseSpec> respPredicate) {
        return this.retry((IRetry)new SimpleRetry(maxAttempts, sleepMillis), respPredicate);
    }

    public HttpRequest retry(IRetry retry) {
        this.retry = retry;
        return this;
    }

    public HttpRequest retry(IRetry retry, Predicate<ResponseSpec> respPredicate) {
        this.retry = retry;
        this.respPredicate = respPredicate;
        return this;
    }

    public HttpRequest hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public HttpRequest sslSocketFactory(SSLSocketFactory sslSocketFactory, @Nullable X509TrustManager trustManager) {
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager == null ? DisableValidationTrustManager.INSTANCE : trustManager;
        return this;
    }

    public HttpRequest useSSL(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        return this.sslSocketFactory(sslSocketFactory, trustManager);
    }

    public HttpRequest useSSL() {
        return this.useSSL((InputStream)null, null);
    }

    public HttpRequest useSSL(String keyStoreFile, String keyPass) {
        return this.useSSL(keyStoreFile, keyPass, null, null);
    }

    public HttpRequest useSSL(String keyStoreFile, String keyPass, String trustStoreFile, String trustPass) {
        Pair<SSLContext, X509TrustManager> pair = HttpRequest.getSslContext(keyStoreFile, keyPass, trustStoreFile, trustPass);
        return this.sslSocketFactory(((SSLContext)pair.getLeft()).getSocketFactory(), (X509TrustManager)pair.getRight());
    }

    public HttpRequest useSSL(InputStream keyStoreInputStream, String keyPass) {
        return this.useSSL(keyStoreInputStream, keyPass, null, null);
    }

    public HttpRequest useSSL(InputStream keyStoreInputStream, String keyPass, InputStream trustInputStream, String trustPass) {
        Pair<SSLContext, X509TrustManager> pair = HttpRequest.getSslContext(keyStoreInputStream, keyPass, trustInputStream, trustPass);
        return this.sslSocketFactory(((SSLContext)pair.getLeft()).getSocketFactory(), (X509TrustManager)pair.getRight());
    }

    public String toString() {
        return this.requestBuilder.toString();
    }

    public static void setHttpClient(OkHttpClient httpClient) {
        HttpRequest.httpClient = httpClient;
    }

    public static void setGlobalDefaultLog(LogLevel logLevel) {
        HttpRequest.setGlobalLog(HttpLoggingInterceptor.Logger.DEFAULT, logLevel);
    }

    public static void setGlobalConsoleLog(LogLevel logLevel) {
        HttpRequest.setGlobalLog(HttpConsoleLogger.INSTANCE, logLevel);
    }

    public static void setGlobalLog(HttpLoggingInterceptor.Logger logger) {
        HttpRequest.setGlobalLog(logger, LogLevel.BODY);
    }

    public static void setGlobalLog(LogLevel logLevel) {
        HttpRequest.setGlobalLog(HttpLogger.Slf4j, logLevel);
    }

    public static void setGlobalLog(HttpLoggingInterceptor.Logger logger, LogLevel logLevel) {
        globalLoggingInterceptor = HttpRequest.getLoggingInterceptor(logger, logLevel);
    }

    public static OkHttpClient setGlobalSSL() {
        return HttpRequest.setGlobalSSL((InputStream)null, null);
    }

    public static OkHttpClient setGlobalSSL(String keyStoreFile, String keyPass) {
        return HttpRequest.setGlobalSSL(keyStoreFile, keyPass, null, null);
    }

    public static OkHttpClient setGlobalSSL(String keyStoreFile, String keyPass, String trustStoreFile, String trustPass) {
        Pair<SSLContext, X509TrustManager> pair = HttpRequest.getSslContext(keyStoreFile, keyPass, trustStoreFile, trustPass);
        return HttpRequest.setGlobalSSL(((SSLContext)pair.getLeft()).getSocketFactory(), (X509TrustManager)pair.getRight());
    }

    public static OkHttpClient setGlobalSSL(InputStream keyStoreInputStream, String keyPass) {
        return HttpRequest.setGlobalSSL(keyStoreInputStream, keyPass, null, null);
    }

    public static OkHttpClient setGlobalSSL(InputStream keyStoreInputStream, String keyPass, InputStream trustInputStream, String trustPass) {
        Pair<SSLContext, X509TrustManager> pair = HttpRequest.getSslContext(keyStoreInputStream, keyPass, trustInputStream, trustPass);
        return HttpRequest.setGlobalSSL(((SSLContext)pair.getLeft()).getSocketFactory(), (X509TrustManager)pair.getRight());
    }

    public static OkHttpClient setGlobalSSL(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        Object tm = trustManager == null ? DisableValidationTrustManager.INSTANCE : trustManager;
        OkHttpClient okHttpClient = httpClient.newBuilder().sslSocketFactory(sslSocketFactory, (X509TrustManager)tm).hostnameVerifier((HostnameVerifier)TrustAllHostNames.INSTANCE).build();
        HttpRequest.setHttpClient(okHttpClient);
        return okHttpClient;
    }

    static String handleValue(@Nullable Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public static Pair<SSLContext, X509TrustManager> getSslContext(String keyStoreFile, String keyPass, String trustStoreFile, String trustPass) {
        InputStream keyStoreInputStream = keyStoreFile == null ? null : (keyStoreFile.toLowerCase().startsWith("classpath:") ? HttpRequest.getResourceAsStream(keyStoreFile) : HttpRequest.getFileResource(keyStoreFile));
        InputStream trustStoreInputStream = trustStoreFile == null ? null : (trustStoreFile.toLowerCase().startsWith("classpath:") ? HttpRequest.getResourceAsStream(trustStoreFile) : HttpRequest.getFileResource(trustStoreFile));
        return HttpRequest.getSslContext(keyStoreInputStream, keyPass, trustStoreInputStream, trustPass);
    }

    public static Pair<SSLContext, X509TrustManager> getSslContext(InputStream keyStoreInputStream, String keyPass, InputStream trustInputStream, String trustPass) {
        try {
            KeyManager[] kms = null;
            TrustManager[] tms = null;
            if (keyStoreInputStream != null) {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance("JKS");
                char[] keyPassChars = keyPass == null ? null : keyPass.toCharArray();
                keyStore.load(keyStoreInputStream, keyPassChars);
                keyManagerFactory.init(keyStore, keyPassChars);
                kms = keyManagerFactory.getKeyManagers();
            }
            if (trustInputStream != null) {
                char[] trustPassChars = trustPass == null ? null : trustPass.toCharArray();
                tms = HttpRequest.getTrustManagers(trustInputStream, trustPassChars);
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kms, tms, new SecureRandom());
            X509TrustManager trustManager = tms == null ? null : (X509TrustManager)tms[0];
            return Pair.create((Object)sslContext, (Object)trustManager);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static TrustManager[] getTrustManagers(InputStream trustInputStream, char[] trustPassword) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        if (trustInputStream == null) {
            return new TrustManager[]{DisableValidationTrustManager.INSTANCE};
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(trustInputStream, trustPassword);
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    private static InputStream getResourceAsStream(String path) {
        if (path.toLowerCase().startsWith("classpath:")) {
            path = path.substring("classpath:".length());
        }
        return HttpRequest.getClassLoader().getResourceAsStream(path);
    }

    private static InputStream getFileResource(String file) {
        try {
            return Files.newInputStream(Paths.get(file, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null && null == (classLoader = ResourceUtil.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

