/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.io.IOException;
import net.dreamlu.mica.http.HttpResponse;
import net.dreamlu.mica.http.ResponseSpec;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class HttpException
extends IOException {
    private final ResponseSpec response;

    HttpException(ResponseSpec response) {
        super(response.toString());
        this.response = response;
    }

    HttpException(Request request, Throwable cause) {
        super(cause);
        this.response = HttpException.getResponse(request, cause.getMessage());
    }

    public ResponseSpec getResponse() {
        return this.response;
    }

    @Override
    public Throwable fillInStackTrace() {
        Throwable cause = super.getCause();
        if (cause == null) {
            return super.fillInStackTrace();
        }
        return cause.fillInStackTrace();
    }

    private static HttpResponse getResponse(Request request, String message) {
        Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).message(message).code(500).build();
        return new HttpResponse(response);
    }
}

