/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.util.Map;
import java.util.function.Consumer;
import net.dreamlu.mica.http.AsyncExchange;
import net.dreamlu.mica.http.Exchange;
import net.dreamlu.mica.http.HttpRequest;
import okhttp3.FormBody;
import org.jspecify.annotations.Nullable;

public class FormBuilder {
    private final HttpRequest request;
    private final FormBody.Builder formBuilder;

    FormBuilder(HttpRequest request) {
        this.request = request;
        this.formBuilder = new FormBody.Builder();
    }

    public FormBuilder add(String name, @Nullable Object value) {
        if (value != null) {
            this.formBuilder.add(name, HttpRequest.handleValue(value));
        }
        return this;
    }

    public FormBuilder addMap(@Nullable Map<String, Object> formMap) {
        if (formMap != null && !formMap.isEmpty()) {
            formMap.forEach(this::add);
        }
        return this;
    }

    public FormBuilder addEncoded(String name, @Nullable Object encodedValue) {
        if (encodedValue != null) {
            this.formBuilder.addEncoded(name, HttpRequest.handleValue(encodedValue));
        }
        return this;
    }

    public FormBuilder add(Consumer<FormBody.Builder> consumer) {
        consumer.accept(this.formBuilder);
        return this;
    }

    public HttpRequest build() {
        return this.request.form(this.formBuilder.build());
    }

    public Exchange execute() {
        return this.build().execute();
    }

    public AsyncExchange async() {
        return this.build().async();
    }
}

