/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.dreamlu.mica.http.AsyncCallback;
import net.dreamlu.mica.http.HttpException;
import net.dreamlu.mica.http.HttpResponse;
import net.dreamlu.mica.http.ResponseSpec;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import org.jspecify.annotations.Nullable;

public class AsyncExchange {
    private final Call call;
    private @Nullable Consumer<ResponseSpec> successConsumer;
    private @Nullable Consumer<ResponseSpec> responseConsumer;
    private @Nullable BiConsumer<Request, HttpException> failedBiConsumer;

    AsyncExchange(Call call) {
        this.call = call;
        this.successConsumer = null;
        this.responseConsumer = null;
        this.failedBiConsumer = null;
    }

    public void onSuccessful(Consumer<ResponseSpec> consumer) {
        this.successConsumer = consumer;
        this.execute();
    }

    public void onResponse(Consumer<ResponseSpec> consumer) {
        this.responseConsumer = consumer;
        this.execute();
    }

    public AsyncExchange onFailed(BiConsumer<Request, HttpException> biConsumer) {
        this.failedBiConsumer = biConsumer;
        return this;
    }

    private void execute() {
        this.call.enqueue((Callback)new AsyncCallback(this));
    }

    public void asVoid() {
        this.execute();
    }

    protected void onResponse(HttpResponse response) {
        if (this.responseConsumer != null) {
            this.responseConsumer.accept(response);
        }
    }

    protected void onSuccessful(HttpResponse response) {
        if (this.successConsumer != null) {
            this.successConsumer.accept(response);
        }
    }

    protected void onFailure(Request request, IOException e) {
        if (this.failedBiConsumer != null) {
            this.failedBiConsumer.accept(request, new HttpException(request, (Throwable)e));
        }
    }

    protected void onFailure(HttpResponse response) {
        if (this.failedBiConsumer != null) {
            this.failedBiConsumer.accept(response.rawRequest(), new HttpException(response));
        }
    }
}

