/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.http;

import java.io.IOException;
import net.dreamlu.mica.http.AsyncExchange;
import net.dreamlu.mica.http.HttpResponse;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class AsyncCallback
implements Callback {
    private final AsyncExchange exchange;

    AsyncCallback(AsyncExchange exchange) {
        this.exchange = exchange;
    }

    public void onFailure(Call call, IOException e) {
        this.exchange.onFailure(call.request(), e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        try (HttpResponse httpResponse = new HttpResponse(response);){
            this.exchange.onResponse(httpResponse);
            if (response.isSuccessful()) {
                this.exchange.onSuccessful(httpResponse);
            } else {
                this.exchange.onFailure(httpResponse);
            }
        }
    }
}

