package net.dongliu.cute.http.jsonb;

import com.google.gson.Gson;
import net.dongliu.cute.http.json.JsonMarshaller;
import org.checkerframework.checker.nullness.qual.Nullable;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Objects;

/**
 * JsonMarshaller Jackson implementation
 */
public class GsonMarshaller implements JsonMarshaller {
    private final Gson gson;

    public GsonMarshaller() {
        this(new Gson());
    }

    public GsonMarshaller(Gson gson) {
        this.gson = Objects.requireNonNull(gson);
    }

    @Override
    public void marshal(@Nullable Object value, Writer writer) throws IOException {
        gson.toJson(value, writer);
    }

    @Override
    public <T> @Nullable T unmarshal(Reader reader, Type type) throws IOException {
        return gson.fromJson(reader, type);
    }
}
