/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.cute.http.jsonb;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Objects;
import net.dongliu.cute.http.json.JsonMarshaller;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GsonMarshaller
implements JsonMarshaller {
    private final Gson gson;

    public GsonMarshaller() {
        this(new Gson());
    }

    public GsonMarshaller(Gson gson) {
        this.gson = Objects.requireNonNull(gson);
    }

    public void marshal(@Nullable Object value, Writer writer) throws IOException {
        this.gson.toJson(value, (Appendable)writer);
    }

    public <T> @Nullable T unmarshal(Reader reader, Type type) throws IOException {
        return (T)this.gson.fromJson(reader, type);
    }
}

