/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.struct;

import net.dongliu.direct.memory.MemoryBuffer;

public class ValueHolder {
    private Object key;
    public final MemoryBuffer memoryBuffer;
    private volatile int expiry = 0;
    private volatile long lastUpdate;

    public ValueHolder(MemoryBuffer memoryBuffer) {
        this.memoryBuffer = memoryBuffer;
        this.lastUpdate = System.currentTimeMillis();
    }

    public int capacity() {
        return this.memoryBuffer.capacity();
    }

    public int size() {
        return this.memoryBuffer.size();
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public byte[] readValue() {
        return this.memoryBuffer.toBytes();
    }

    public void dispose() {
        this.memoryBuffer.dispose();
    }

    public boolean expired() {
        long cur = System.currentTimeMillis();
        return this.expiry > 0 && cur - this.lastUpdate > (long)this.expiry;
    }

    public void lastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public long lastUpdate() {
        return this.lastUpdate;
    }

    public int expiry() {
        return this.expiry;
    }

    public void expiry(int expiry) {
        this.expiry = expiry;
    }

    public MemoryBuffer getMemoryBuffer() {
        return this.memoryBuffer;
    }
}

