/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.memory.slabs;

import net.dongliu.direct.memory.MemoryBuffer;
import net.dongliu.direct.memory.UnsafeMemory;
import net.dongliu.direct.memory.slabs.SlabsAllocator;

public class UnPooledBuffer
extends MemoryBuffer {
    private final UnsafeMemory memory;
    private SlabsAllocator allocator;

    private UnPooledBuffer(SlabsAllocator allocator, UnsafeMemory memory) {
        this.memory = memory;
        this.allocator = allocator;
    }

    public static UnPooledBuffer allocate(SlabsAllocator allocator, int size) {
        UnsafeMemory memory = UnsafeMemory.allocate(size);
        return new UnPooledBuffer(allocator, memory);
    }

    @Override
    public int capacity() {
        return this.memory.getSize();
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    public UnsafeMemory getMemory() {
        return this.memory;
    }

    @Override
    public void dispose() {
        this.allocator.used.addAndGet(-this.memory.getSize());
        this.allocator.actualUsed.addAndGet(-this.memory.getSize());
        this.memory.dispose();
    }
}

