/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.memory.slabs;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import net.dongliu.direct.memory.Allocator;
import net.dongliu.direct.memory.MemoryBuffer;
import net.dongliu.direct.memory.slabs.Chunk;
import net.dongliu.direct.memory.slabs.SlabClass;
import net.dongliu.direct.memory.slabs.UnPooledBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlabsAllocator
implements Allocator {
    private final float expandFactor;
    protected final int chunkSize;
    protected final int slabSize;
    protected final int[] CHUNK_SIZE_LIST;
    private static final int CHUNK_SIZE_MASK = -4;
    private final SlabClass[] slabClasses;
    protected final long capacity;
    protected final AtomicLong used = new AtomicLong(0L);
    protected final AtomicLong actualUsed = new AtomicLong(0L);
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SlabsAllocator(long capacity, float expandFactor, int chunkSize, int slabSize) {
        int i;
        this.expandFactor = expandFactor;
        this.chunkSize = chunkSize;
        this.slabSize = slabSize;
        double size = this.chunkSize;
        ArrayList<Integer> ilist = new ArrayList<Integer>();
        while (((int)size & 0xFFFFFFFC) <= this.slabSize) {
            ilist.add((int)size & 0xFFFFFFFC);
            size *= (double)expandFactor;
        }
        this.CHUNK_SIZE_LIST = new int[ilist.size()];
        for (i = 0; i < ilist.size(); ++i) {
            this.CHUNK_SIZE_LIST[i] = (Integer)ilist.get(i);
        }
        this.CHUNK_SIZE_LIST[this.CHUNK_SIZE_LIST.length - 1] = this.slabSize;
        this.capacity = capacity;
        this.slabClasses = new SlabClass[this.CHUNK_SIZE_LIST.length];
        for (i = 0; i < this.CHUNK_SIZE_LIST.length; ++i) {
            SlabClass slabClass;
            this.slabClasses[i] = slabClass = new SlabClass(this, this.CHUNK_SIZE_LIST[i]);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("new slab allocator, capacity:" + this.capacity);
            this.logger.debug("chunk size:" + this.chunkSize);
            this.logger.debug("slab size:" + this.slabSize);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public MemoryBuffer allocate(int size) {
        void var2_4;
        if (size <= 0) {
            throw new IllegalArgumentException("size must be large than 0");
        }
        if (size > this.slabSize) {
            if (this.used.addAndGet(size) < this.capacity) {
                this.actualUsed.addAndGet(size);
                UnPooledBuffer unPooledBuffer = UnPooledBuffer.allocate(this, size);
                return var2_4;
            }
            this.used.addAndGet(-size);
            return null;
        }
        SlabClass slabClass = this.locateSlabClass(size);
        Chunk chunk = slabClass.newChunk();
        if (chunk == null) {
            return null;
        }
        this.actualUsed.addAndGet(chunk.capacity());
        Chunk chunk2 = chunk;
        return var2_4;
    }

    private SlabClass locateSlabClass(int size) {
        int left = 0;
        int right = this.slabClasses.length - 1;
        int mid = 0;
        while (left <= right) {
            mid = left + (right - left) / 2;
            if (size > this.slabClasses[mid].chunkSize) {
                left = mid + 1;
                continue;
            }
            if (size < this.slabClasses[mid].chunkSize) {
                right = mid - 1;
                continue;
            }
            return this.slabClasses[mid];
        }
        if (this.slabClasses[mid].chunkSize < size) {
            while (this.slabClasses[++mid].chunkSize < size) {
            }
            return this.slabClasses[mid];
        }
        while (--mid >= 0 && this.slabClasses[mid].chunkSize > size) {
        }
        return this.slabClasses[mid + 1];
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long actualUsed() {
        return this.actualUsed.longValue();
    }

    @Override
    public long used() {
        return this.used.longValue();
    }

    @Override
    public void destroy() {
        for (int i = 0; i < this.slabClasses.length; ++i) {
            this.slabClasses[i].destroy();
            this.slabClasses[i] = null;
        }
    }
}

