/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.memory.slabs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.dongliu.direct.memory.slabs.Chunk;
import net.dongliu.direct.memory.slabs.Slab;
import net.dongliu.direct.memory.slabs.SlabsAllocator;

class SlabClass {
    protected final int chunkSize;
    private final List<Slab> slabList;
    private volatile Slab curSlab;
    protected final SlabsAllocator allocator;
    private final ConcurrentLinkedQueue<Chunk> freeChunkQueue;
    private final Object expandLock = new Object();

    public SlabClass(SlabsAllocator allocator, int chunkSize) {
        this.allocator = allocator;
        this.chunkSize = chunkSize;
        this.slabList = new ArrayList<Slab>();
        this.freeChunkQueue = new ConcurrentLinkedQueue();
    }

    public void freeChunk(Chunk chunk) {
        this.allocator.actualUsed.addAndGet(-this.chunkSize);
        this.freeChunkQueue.add(chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk newChunk() {
        Chunk chunk;
        if (this.curSlab == null) {
            Object object = this.expandLock;
            synchronized (object) {
                if (this.curSlab == null) {
                    this.newSlab();
                }
            }
        }
        if ((chunk = this.freeChunkQueue.poll()) != null) {
            return chunk;
        }
        chunk = this.curSlab.nextChunk();
        if (chunk != null) {
            return chunk;
        }
        Object object = this.expandLock;
        synchronized (object) {
            chunk = this.curSlab.nextChunk();
            if (chunk != null) {
                return chunk;
            }
            this.newSlab();
            if (this.curSlab == null) {
                return null;
            }
            chunk = this.curSlab.nextChunk();
            return chunk;
        }
    }

    private void newSlab() {
        if (this.allocator.used.addAndGet(this.allocator.chunkSize) < this.allocator.capacity) {
            this.curSlab = Slab.newInstance(this, this.allocator.slabSize, this.chunkSize);
            this.slabList.add(this.curSlab);
        } else {
            this.allocator.used.addAndGet(-this.allocator.chunkSize);
        }
    }

    public void destroy() {
        for (Slab slab : this.slabList) {
            slab.destroy();
        }
        this.slabList.clear();
        this.freeChunkQueue.clear();
    }
}

