/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.memory.slabs;

import java.util.concurrent.atomic.AtomicInteger;
import net.dongliu.direct.memory.UnsafeMemory;
import net.dongliu.direct.memory.slabs.Chunk;
import net.dongliu.direct.memory.slabs.SlabClass;

class Slab {
    private final AtomicInteger idx = new AtomicInteger(0);
    private final SlabClass slabClass;
    private UnsafeMemory memory;
    protected final int chunkSize;

    private Slab(SlabClass slabClass, UnsafeMemory memory, int chunkSize) {
        this.slabClass = slabClass;
        this.memory = memory;
        this.chunkSize = chunkSize;
    }

    public static Slab newInstance(SlabClass slabClass, int size, int chunkSize) {
        UnsafeMemory memory = UnsafeMemory.allocate(size);
        return new Slab(slabClass, memory, chunkSize);
    }

    public Chunk nextChunk() {
        int total;
        int freeChunkIdx = this.idx.getAndIncrement();
        if (freeChunkIdx < (total = this.memory.getSize() / this.chunkSize)) {
            return Chunk.make(this, freeChunkIdx * this.chunkSize);
        }
        this.idx.getAndDecrement();
        return null;
    }

    public void destroy() {
        this.memory.dispose();
    }

    public SlabClass getSlabClass() {
        return this.slabClass;
    }

    public UnsafeMemory getMemory() {
        return this.memory;
    }
}

