/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.direct.memory;

import net.dongliu.direct.utils.U;

public class UnsafeMemory {
    private final long address;
    private final int size;

    private UnsafeMemory(int size) {
        this.size = size;
        this.address = U.allocateMemory(size);
    }

    public static UnsafeMemory allocate(int size) {
        return new UnsafeMemory(size);
    }

    public void write(long pos, byte[] src, int offset, int size) {
        U.write(this.address + pos, src, offset, size);
    }

    public void write(long pos, byte[] src, int size) {
        U.write(this.address + pos, src, 0, size);
    }

    public void write(long pos, byte[] src) {
        U.write(this.address + pos, src, 0, src.length);
    }

    public void read(long pos, byte[] src, int offset, int size) {
        U.read(this.address + pos, src, offset, size);
    }

    public void read(long pos, byte[] src, int size) {
        U.read(this.address + pos, src, 0, size);
    }

    public void read(long pos, byte[] src) {
        U.read(this.address + pos, src, 0, src.length);
    }

    public void dispose() {
        U.freeMemory(this.address);
    }

    public int getSize() {
        return this.size;
    }

    public byte read(long pos) {
        return U.getByte(this.address + pos);
    }
}

